/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalProperties {
    private static final Log log = LogFactory.getLog(HierarchicalProperties.class);
    public static final String ODE_PREFFIX = "ode";
    private File[] files;
    private String prefix;
    private String dotted_prefix;
    private MultiKeyMap hierarchicalMap = new MultiKeyMap();
    private transient MultiKeyMap cacheOfImmutableMaps = new MultiKeyMap();

    public HierarchicalProperties(File[] files, String prefix) throws IOException {
        this.files = files;
        this.prefix = prefix;
        this.dotted_prefix = "." + prefix + ".";
        this.loadFiles();
    }

    public HierarchicalProperties(File[] files) throws IOException {
        this(files, ODE_PREFFIX);
    }

    public HierarchicalProperties(File file, String prefix) throws IOException {
        this(new File[]{file}, prefix);
    }

    public HierarchicalProperties(File file) throws IOException {
        this(new File[]{file}, ODE_PREFFIX);
    }

    public HierarchicalProperties(List<File> propFiles) throws IOException {
        this(propFiles.toArray(new File[propFiles.size()]), ODE_PREFFIX);
    }

    public void loadFiles() throws IOException {
        this.clear();
        this.initRoot();
        for (File file : this.files) {
            Properties props = this.loadFile(file);
            if (props.isEmpty()) continue;
            this.processProperties(props, file);
        }
        this.replacePlaceholders();
    }

    private ChainedMap initRoot() {
        ChainedMap root = new ChainedMap();
        this.hierarchicalMap.put(null, null, (Object)root);
        return root;
    }

    private void processProperties(Properties props, File file) throws IOException {
        this.validatePropertyNames(props, file);
        Map<String, String> nsByAlias = this.collectAliases(props, file);
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            ChainedMap p;
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            String[] info = this.parseProperty(key);
            String nsalias = info[0];
            String service = info[1];
            String port = info[2];
            String targetedProperty = info[3];
            QName qname = null;
            if (nsalias != null) {
                qname = new QName(nsByAlias.get(nsalias) != null ? nsByAlias.get(nsalias) : nsalias, service);
            }
            if ((p = (ChainedMap)this.hierarchicalMap.get(qname, (Object)port)) == null) {
                ChainedMap s = (ChainedMap)this.hierarchicalMap.get((Object)qname, null);
                if (s == null) {
                    s = new ChainedMap(this.getRootMap());
                    this.hierarchicalMap.put((Object)qname, null, (Object)s);
                }
                p = new ChainedMap(s);
                this.hierarchicalMap.put((Object)qname, (Object)port, (Object)p);
            }
            if (targetedProperty.endsWith(".file") || targetedProperty.endsWith(".path")) {
                String absolutePath = file.toURI().resolve(value).getPath();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("path: " + value + " resolved into: " + absolutePath));
                }
                value = absolutePath;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("New property: " + targetedProperty + " -> " + value));
            }
            p.put(targetedProperty, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadFile(File file) throws IOException {
        Properties props = new Properties();
        if (!file.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("File does not exist [" + file + "]"));
            }
            return props;
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading property file: " + file));
            }
            props.load(fis);
        }
        finally {
            fis.close();
        }
        return props;
    }

    private Map<String, String> collectAliases(Properties props, File file) {
        HashMap<String, String> nsByAlias = new HashMap<String, String>();
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> e = it.next();
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            if (!key.startsWith("alias.")) continue;
            String alias = key.substring("alias.".length(), key.length());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Alias found: " + alias + " -> " + value));
            }
            if (nsByAlias.containsKey(alias) && value.equals(nsByAlias.get(alias))) {
                throw new RuntimeException("Same alias used twice for 2 different namespaces! file=" + file + ", alias=" + alias);
            }
            nsByAlias.put(alias, value);
            it.remove();
        }
        return nsByAlias;
    }

    private void validatePropertyNames(Properties props, File file) {
        ArrayList<String> invalids = new ArrayList<String>();
        for (String string : props.keySet()) {
            if (!string.startsWith("system.") && !string.startsWith("env.")) continue;
            invalids.add(string);
        }
        if (!invalids.isEmpty()) {
            throw new IllegalArgumentException("Property files cannot define properties starting with 'system.' nor 'env.' File=" + file + ". Invalid names=" + StringUtils.join(invalids, (String)","));
        }
    }

    private void replacePlaceholders() {
        Pattern systemProperty = Pattern.compile("\\$\\{system\\.([^\\}]+)\\}");
        Pattern environmentVariable = Pattern.compile("\\$\\{env\\.([^\\}]+)\\}");
        Pattern localPlaceholder = Pattern.compile("\\$\\{([^\\}]+)\\}");
        Iterator it = this.hierarchicalMap.values().iterator();
        while (it.hasNext()) {
            Map properties = ((ChainedMap)it.next()).child;
            for (Map.Entry entry : properties.entrySet()) {
                entry.setValue(SystemUtils.replaceProperties((String)entry.getValue(), localPlaceholder, this.getRootMap().child));
                entry.setValue(SystemUtils.replaceProperties((String)entry.getValue(), systemProperty, System.getProperties()));
                entry.setValue(SystemUtils.replaceProperties((String)entry.getValue(), environmentVariable, System.getenv()));
            }
        }
    }

    public void clear() {
        this.hierarchicalMap.clear();
        this.cacheOfImmutableMaps.clear();
    }

    protected ChainedMap getRootMap() {
        Object o = this.hierarchicalMap.get(null, null);
        if (o == null) {
            o = this.initRoot();
        }
        return (ChainedMap)o;
    }

    public Map getProperties(String serviceNamespaceURI, String serviceLocalPart) {
        return this.getProperties(new QName(serviceNamespaceURI, serviceLocalPart));
    }

    public Map getProperties(QName service) {
        return this.getProperties(service, null);
    }

    public Map getProperties(String serviceNamespaceURI, String serviceLocalPart, String port) {
        return this.getProperties(new QName(serviceNamespaceURI, serviceLocalPart), port);
    }

    public Map getProperties(QName service, String port) {
        if (this.hierarchicalMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Map cachedMap = (Map)this.cacheOfImmutableMaps.get((Object)service, (Object)port);
        if (cachedMap != null) {
            return cachedMap;
        }
        ChainedMap cm = (ChainedMap)this.hierarchicalMap.get((Object)service, (Object)port);
        if (cm == null && (cm = (ChainedMap)this.hierarchicalMap.get((Object)service, null)) == null) {
            return this.getProperties((QName)null, null);
        }
        Map snapshotMap = new HashMap(cm.size() * 15 / 10);
        for (Object key : cm.keySet()) {
            snapshotMap.put(key, cm.get(key));
        }
        snapshotMap = Collections.unmodifiableMap(snapshotMap);
        this.cacheOfImmutableMaps.put((Object)service, (Object)port, snapshotMap);
        return snapshotMap;
    }

    public String getProperty(String property) {
        return (String)this.getRootMap().get(property);
    }

    public String getProperty(String serviceNamespaceURI, String serviceLocalPart, String property) {
        return this.getProperty(new QName(serviceNamespaceURI, serviceLocalPart), property);
    }

    public String getProperty(QName service, String property) {
        return this.getProperty(service, null, property);
    }

    public String getProperty(String serviceNamespaceURI, String serviceLocalPart, String port, String property) {
        return this.getProperty(new QName(serviceNamespaceURI, serviceLocalPart), port, property);
    }

    public String getProperty(QName service, String port, String property) {
        return (String)this.getProperties(service, port).get(property);
    }

    public String getPrefix() {
        return this.prefix;
    }

    private String[] parseProperty(String property) {
        String[] res = new String[4];
        int index = property.indexOf(this.dotted_prefix);
        if (index <= 0) {
            res[3] = property;
        } else {
            res[3] = property.substring(index + this.dotted_prefix.length());
            String prefix = property.substring(0, index);
            String[] t = prefix.split("\\.");
            if (t.length != 2 && t.length != 3) {
                throw new IllegalArgumentException("Invalid property name:" + property + " Expected pattern: [nsalias.service.[port.]" + prefix + ".]property");
            }
            if (t.length >= 2) {
                res[0] = t[0];
                res[1] = t[1];
            }
            if (t.length > 2) {
                res[2] = t[2];
            }
        }
        return res;
    }

    private static class ChainedMap {
        private ChainedMap parent;
        private Map child;

        public ChainedMap() {
            this.parent = null;
            this.child = new HashMap();
        }

        public ChainedMap(ChainedMap parent) {
            this.parent = parent;
            this.child = new HashMap();
        }

        public ChainedMap getParent() {
            return this.parent;
        }

        public void setParent(ChainedMap parent) {
            this.parent = parent;
        }

        public Object getLocally(Object key) {
            return this.child.get(key);
        }

        public void clearLocally() {
            this.child.clear();
        }

        public Object get(Object key) {
            Object lv = this.getLocally(key);
            if (lv != null) {
                return lv;
            }
            if (this.parent != null) {
                return this.parent.get(key);
            }
            return null;
        }

        public Object put(Object key, Object value) {
            if (key == null) {
                throw new NullPointerException("Null keys forbidden!");
            }
            return this.child.put(key, value);
        }

        public void putAll(Map t) {
            for (Map.Entry e : t.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return this.child.isEmpty() && (this.parent == null || this.parent.isEmpty());
        }

        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException("Null keys forbidden!");
            }
            return this.child.containsKey(key) || this.parent != null && this.parent.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.child.containsValue(value) || this.parent != null && this.parent.containsValue(value);
        }

        public int size() {
            return this.keySet().size();
        }

        public Set keySet() {
            HashSet s = new HashSet(this.child.keySet());
            if (this.parent != null) {
                s.addAll(this.parent.keySet());
            }
            return s;
        }
    }
}

