/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import javax.xml.namespace.QName;

public class QNameUtils {
    private QNameUtils() {
    }

    public static String fromQName(QName qname) {
        return "{" + qname.getNamespaceURI() + "}" + qname.getLocalPart();
    }

    public static QName toQName(String s) {
        if (s.charAt(0) != '{') {
            throw new IllegalArgumentException("Malformed QNAME: " + s);
        }
        int idx = s.lastIndexOf(125);
        if (idx == 0) {
            throw new IllegalArgumentException("Malformed QNAME: " + s);
        }
        return new QName(s.substring(1, idx), s.substring(idx + 1, s.length()));
    }
}

