/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.scheduler.simple;

import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.scheduler.simple.DatabaseDelegate;
import org.apache.ode.scheduler.simple.DatabaseException;
import org.apache.ode.scheduler.simple.Job;
import org.apache.ode.utils.DbIsolation;
import org.apache.ode.utils.StreamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDelegate
implements DatabaseDelegate {
    private static final Log __log = LogFactory.getLog(JdbcDelegate.class);
    private static final String DELETE_JOB = "delete from ODE_JOB where jobid = ? and nodeid = ?";
    private static final String UPDATE_REASSIGN = "update ODE_JOB set nodeid = ?, scheduled = 0 where nodeid = ?";
    private static final String UPDATE_JOB = "update ODE_JOB set ts = ?, details = ? where jobid = ?";
    private static final String UPGRADE_JOB_DEFAULT = "update ODE_JOB set nodeid = ? where nodeid is null and mod(ts,?) = ? and ts < ?";
    private static final String UPGRADE_JOB_DB2 = "update ODE_JOB set nodeid = ? where nodeid is null and mod(ts,CAST(? AS BIGINT)) = ? and ts < ?";
    private static final String UPGRADE_JOB_SQLSERVER = "update ODE_JOB set nodeid = ? where nodeid is null and (ts % ?) = ? and ts < ?";
    private static final String UPGRADE_JOB_SYBASE = "update ODE_JOB set nodeid = ? where nodeid is null and convert(int, ts) % ? = ? and ts < ?";
    private static final String UPGRADE_JOB_SYBASE12 = "update ODE_JOB set nodeid = ? where nodeid is null and -1 <> ? and -1 <> ? and ts < ?";
    private static final String SAVE_JOB = "insert into ODE_JOB  (jobid, nodeid, ts, scheduled, transacted, details) values(?, ?, ?, ?, ?, ?)";
    private static final String GET_NODEIDS = "select distinct nodeid from ODE_JOB";
    private static final String SCHEDULE_IMMEDIATE = "select jobid, ts, transacted, scheduled, details from ODE_JOB where nodeid = ? and ts < ? order by ts";
    private DataSource _ds;
    private Dialect _dialect;

    public JdbcDelegate(DataSource ds) {
        this._ds = ds;
        this._dialect = this.guessDialect();
    }

    @Override
    public boolean deleteJob(String jobid, String nodeId) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("deleteJob " + jobid + " on node " + nodeId));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(DELETE_JOB);
            ps.setString(1, jobid);
            ps.setString(2, nodeId);
            boolean bl = ps.executeUpdate() == 1;
            this.close(ps);
            this.close(con);
            return bl;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    @Override
    public List<String> getNodeIds() throws DatabaseException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(GET_NODEIDS, 1003, 1007);
            ResultSet rs = ps.executeQuery();
            ArrayList<String> nodes = new ArrayList<String>();
            while (rs.next()) {
                String nodeId = rs.getString(1);
                if (nodeId == null) continue;
                nodes.add(rs.getString(1));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("getNodeIds: " + nodes));
            }
            ArrayList<String> arrayList = nodes;
            this.close(ps);
            this.close(con);
            return arrayList;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    @Override
    public boolean insertJob(Job job, String nodeId, boolean loaded) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("insertJob " + job.jobId + " on node " + nodeId + " loaded=" + loaded));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(SAVE_JOB);
            ps.setString(1, job.jobId);
            ps.setString(2, nodeId);
            ps.setLong(3, job.schedDate);
            ps.setInt(4, this.asInteger(loaded));
            ps.setInt(5, this.asInteger(job.transacted));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                StreamUtils.write((OutputStream)bos, (Serializable)((Serializable)((Object)job.detail)));
            }
            catch (Exception ex) {
                __log.error((Object)("Error serializing job detail: " + job.detail));
                throw new DatabaseException(ex);
            }
            ps.setBytes(6, bos.toByteArray());
            boolean bl = ps.executeUpdate() == 1;
            this.close(ps);
            this.close(con);
            return bl;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    @Override
    public boolean updateJob(Job job) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("updateJob " + job.jobId + " details=" + job));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(UPDATE_JOB);
            ps.setLong(1, job.schedDate);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                StreamUtils.write((OutputStream)bos, (Serializable)((Serializable)((Object)job.detail)));
            }
            catch (Exception ex) {
                __log.error((Object)("Error serializing job detail: " + job.detail));
                throw new DatabaseException(ex);
            }
            ps.setBytes(2, bos.toByteArray());
            ps.setString(3, job.jobId);
            boolean bl = ps.executeUpdate() == 1;
            this.close(ps);
            this.close(con);
            return bl;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    @Override
    public List<Job> dequeueImmediate(String nodeId, long maxtime, int maxjobs) throws DatabaseException {
        ArrayList<Job> ret = new ArrayList<Job>(maxjobs);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(SCHEDULE_IMMEDIATE);
            ps.setString(1, nodeId);
            ps.setLong(2, maxtime);
            ps.setMaxRows(maxjobs);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Map details;
                try {
                    ObjectInputStream is = new ObjectInputStream(rs.getBinaryStream(5));
                    details = (Map)is.readObject();
                    is.close();
                }
                catch (Exception e) {
                    throw new DatabaseException("Error deserializing job details", e);
                }
                Job job = new Job(rs.getLong(2), rs.getString(1), this.asBoolean(rs.getInt(3)), details);
                ret.add(job);
            }
            rs.close();
            ps.close();
            this.close(ps);
            this.close(con);
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
        return ret;
    }

    @Override
    public int updateReassign(String oldnode, String newnode) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("updateReassign from " + oldnode + " ---> " + newnode));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(UPDATE_REASSIGN);
            ps.setString(1, newnode);
            ps.setString(2, oldnode);
            int n = ps.executeUpdate();
            this.close(ps);
            this.close(con);
            return n;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    @Override
    public int updateAssignToNode(String node, int i, int numNodes, long maxtime) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("updateAsssignToNode node=" + node + " " + i + "/" + numNodes + " maxtime=" + maxtime));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this._dialect == Dialect.SQLSERVER ? con.prepareStatement(UPGRADE_JOB_SQLSERVER) : (this._dialect == Dialect.DB2 ? con.prepareStatement(UPGRADE_JOB_DB2) : (this._dialect == Dialect.SYBASE ? con.prepareStatement(UPGRADE_JOB_SYBASE) : (this._dialect == Dialect.SYBASE12 ? con.prepareStatement(UPGRADE_JOB_SYBASE12) : con.prepareStatement(UPGRADE_JOB_DEFAULT))));
            ps.setString(1, node);
            ps.setInt(2, numNodes);
            ps.setInt(3, i);
            ps.setLong(4, maxtime);
            int n = ps.executeUpdate();
            this.close(ps);
            this.close(con);
            return n;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    private Connection getConnection() throws SQLException {
        Connection c = this._ds.getConnection();
        DbIsolation.setIsolationLevel((Connection)c);
        return c;
    }

    private int asInteger(boolean value) {
        return value ? 1 : 0;
    }

    private boolean asBoolean(int value) {
        return value != 0;
    }

    private void close(PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Exception e) {
                __log.warn((Object)"Exception while closing prepared statement", (Throwable)e);
            }
        }
    }

    private void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                __log.warn((Object)"Exception while closing connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dialect guessDialect() {
        Dialect d = Dialect.UNKNOWN;
        Connection con = null;
        try {
            con = this.getConnection();
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData != null) {
                String dbProductName = metaData.getDatabaseProductName();
                int dbMajorVer = metaData.getDatabaseMajorVersion();
                __log.info((Object)("Using database " + dbProductName + " major version " + dbMajorVer));
                if (dbProductName.indexOf("DB2") >= 0) {
                    d = Dialect.DB2;
                } else if (dbProductName.indexOf("Derby") >= 0) {
                    d = Dialect.DERBY;
                } else if (dbProductName.indexOf("Firebird") >= 0) {
                    d = Dialect.FIREBIRD;
                } else if (dbProductName.indexOf("HSQL") >= 0) {
                    d = Dialect.HSQL;
                } else if (dbProductName.indexOf("Microsoft SQL") >= 0) {
                    d = Dialect.SQLSERVER;
                } else if (dbProductName.indexOf("MySQL") >= 0) {
                    d = Dialect.MYSQL;
                } else if (dbProductName.indexOf("Sybase") >= 0 || dbProductName.indexOf("Adaptive") >= 0) {
                    d = Dialect.SYBASE;
                    if (dbMajorVer == 12) {
                        d = Dialect.SYBASE12;
                    }
                }
            }
        }
        catch (SQLException e) {
            __log.warn((Object)"Unable to determine database dialect", (Throwable)e);
        }
        finally {
            this.close(con);
        }
        __log.info((Object)("Using database dialect: " + (Object)((Object)d)));
        return d;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Dialect {
        DB2,
        DERBY,
        FIREBIRD,
        HSQL,
        MYSQL,
        ORACLE,
        SQLSERVER,
        SYBASE,
        SYBASE12,
        UNKNOWN;

    }
}

