/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store.hib;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.daohib.HibernateTransactionManagerLookup;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.store.ConfStoreConnectionFactory;
import org.apache.ode.store.Messages;
import org.apache.ode.store.hib.ConfStoreConnectionHib;
import org.apache.ode.store.hib.DeploymentUnitDaoImpl;
import org.apache.ode.store.hib.ProcessConfDaoImpl;
import org.apache.ode.store.hib.VersionTrackerDAOImpl;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.msg.MessageBundle;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;

public class DbConfStoreConnectionFactory
implements ConfStoreConnectionFactory {
    private static final Log __log = LogFactory.getLog(DbConfStoreConnectionFactory.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private static final String DEFAULT_HIBERNATE_DIALECT = "org.hibernate.dialect.DerbyDialect";
    private static final HashMap<String, DialectFactory.VersionInsensitiveMapper> HIBERNATE_DIALECTS = new HashMap();
    private static final String _guid = new GUID().toString();
    private static final Map<String, DataSource> _dataSources = new ConcurrentHashMap<String, DataSource>();
    private TransactionManager _txMgr;
    private final DataSource _ds;
    final SessionFactory _sessionFactory;

    public DbConfStoreConnectionFactory(DataSource ds, Properties initialProps, boolean createDatamodel, String txFactoryClassName) {
        this._ds = ds;
        Properties properties = new Properties();
        for (Object prop : initialProps.keySet()) {
            properties.put(prop, initialProps.get(prop));
        }
        __log.debug((Object)("using data source: " + ds));
        _dataSources.put(_guid, ds);
        if (properties.get("hibernate.dialect") == null) {
            try {
                properties.put("hibernate.dialect", this.guessDialect(this._ds));
            }
            catch (Exception ex) {
                String errmsg = __msgs.msgOdeInitHibernateDialectDetectFailed();
                __log.error((Object)errmsg, (Throwable)ex);
                throw new BpelEngineException(errmsg, (Throwable)ex);
            }
        }
        if (createDatamodel) {
            properties.put("hibernate.hbm2ddl.auto", "create-drop");
        }
        if (properties.containsKey("hibernate.connection.provider_class")) {
            __log.warn((Object)"Ignoring user-specified Hibernate property: hibernate.connection.provider_class");
        }
        if (properties.containsKey("hibernate.transaction.manager_lookup_class")) {
            __log.warn((Object)"Ignoring user-specified Hibernate property: hibernate.transaction.manager_lookup_class");
        }
        if (properties.containsKey("hibernate.session_factory_name")) {
            __log.warn((Object)"Ignoring user-specified Hibernate property: hibernate.session_factory_name");
        }
        properties.put("ode.hibernate.guid", _guid);
        properties.put("hibernate.connection.provider_class", DataSourceConnectionProvider.class.getName());
        properties.put("hibernate.transaction.manager_lookup_class", HibernateTransactionManagerLookup.class.getName());
        properties.put("hibernate.transaction.factory_class", "org.hibernate.transaction.JTATransactionFactory");
        properties.put("hibernate.current_session_context_class", "jta");
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Store connection properties: " + properties));
        }
        this.initTxMgr(txFactoryClassName);
        SessionManager.registerTransactionManager((String)_guid, (TransactionManager)this._txMgr);
        this._sessionFactory = DbConfStoreConnectionFactory.getDefaultConfiguration().setProperties(properties).buildSessionFactory();
    }

    public ConfStoreConnectionHib getConnection() {
        return new ConfStoreConnectionHib((Session)this._sessionFactory.getCurrentSession());
    }

    private void initTxMgr(String txFactoryClassName) {
        __log.info((Object)("ProcessStore initializing transaction manager using " + txFactoryClassName));
        try {
            Class<?> txFactClass = this.getClass().getClassLoader().loadClass(txFactoryClassName);
            Object txFact = txFactClass.newInstance();
            this._txMgr = (TransactionManager)txFactClass.getMethod("getTransactionManager", null).invoke(txFact, new Object[0]);
        }
        catch (Exception e) {
            __log.fatal((Object)("Couldn't initialize a transaction manager with factory: " + txFactoryClassName), (Throwable)e);
            throw new RuntimeException("Couldn't initialize a transaction manager with factory: " + txFactoryClassName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessDialect(DataSource dataSource) throws Exception {
        String dialect = null;
        Connection conn = dataSource.getConnection();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            if (metaData != null) {
                String dbProductName = metaData.getDatabaseProductName();
                int dbMajorVer = metaData.getDatabaseMajorVersion();
                __log.info((Object)("Using database " + dbProductName + " major version " + dbMajorVer));
                DialectFactory.DatabaseDialectMapper mapper = (DialectFactory.DatabaseDialectMapper)HIBERNATE_DIALECTS.get(dbProductName);
                if (mapper != null) {
                    dialect = mapper.getDialectClass(dbMajorVer);
                } else {
                    Dialect hbDialect = DialectFactory.determineDialect((String)dbProductName, (int)dbMajorVer);
                    if (hbDialect != null) {
                        dialect = hbDialect.getClass().getName();
                    }
                }
            }
        }
        finally {
            conn.close();
        }
        if (dialect == null) {
            __log.info((Object)"Cannot determine hibernate dialect for this database: using the default one.");
            dialect = DEFAULT_HIBERNATE_DIALECT;
        }
        return dialect;
    }

    public void beginTransaction() {
        try {
            this._txMgr.begin();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void commitTransaction() {
        try {
            this._txMgr.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void rollbackTransaction() {
        try {
            this._txMgr.rollback();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static Configuration getDefaultConfiguration() throws MappingException {
        return new Configuration().addClass(ProcessConfDaoImpl.class).addClass(DeploymentUnitDaoImpl.class).addClass(VersionTrackerDAOImpl.class);
    }

    static {
        HIBERNATE_DIALECTS.put("Apache Derby", new DialectFactory.VersionInsensitiveMapper(DEFAULT_HIBERNATE_DIALECT));
    }

    public static class DataSourceConnectionProvider
    implements ConnectionProvider {
        private String _guid;

        public void configure(Properties props) throws HibernateException {
            this._guid = props.getProperty("ode.hibernate.guid");
        }

        public Connection getConnection() throws SQLException {
            return ((DataSource)_dataSources.get(this._guid)).getConnection();
        }

        public void closeConnection(Connection arg0) throws SQLException {
            arg0.close();
        }

        public void close() throws HibernateException {
        }

        public boolean supportsAggressiveRelease() {
            return true;
        }
    }
}

