/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.xml.XMLFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLErrorCodeReader {
    private Log log = null;
    public static final String ERROR_CODE_DELIMITER = ",";
    public static final Map<String, Integer> storeErrorTypes = new HashMap<String, Integer>();
    private static final Localizer _loc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDictionaries(InputStream in) {
        ArrayList<String> result = new ArrayList<String>();
        DocumentBuilder builder = XMLFactory.getDOMParser(false, false);
        try {
            Document doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodes = root.getElementsByTagName("dictionary");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                NamedNodeMap attrs = node.getAttributes();
                Node dictionary = attrs.getNamedItem("class");
                if (dictionary == null) continue;
                result.add(dictionary.getNodeValue());
            }
        }
        catch (Throwable e) {
            if (this.log.isWarnEnabled()) {
                this.log.error(_loc.get("error-code-parse-error"));
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream in, String dictName, DBDictionary dict) {
        if (in == null || dict == null) {
            return;
        }
        this.log = dict.conf.getLog("openjpa.jdbc.JDBC");
        DocumentBuilder builder = XMLFactory.getDOMParser(false, false);
        try {
            Document doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodes = root.getElementsByTagName("dictionary");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                NamedNodeMap attrs = node.getAttributes();
                Node dictionary = attrs.getNamedItem("class");
                if (dictionary == null || !dictionary.getNodeValue().equals(dictName)) continue;
                SQLErrorCodeReader.readErrorCodes(node, dict);
            }
        }
        catch (Throwable e) {
            if (this.log.isWarnEnabled()) {
                this.log.error(_loc.get("error-code-parse-error"));
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    static void readErrorCodes(Node node, DBDictionary dict) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String[] codes;
            String errorCodes;
            Node child = children.item(i);
            short nodeType = child.getNodeType();
            if (nodeType != 1) continue;
            String errorType = child.getNodeName();
            Node textNode = child.getFirstChild();
            if (!storeErrorTypes.containsKey(errorType) || textNode == null || StringUtils.isEmpty((String)(errorCodes = textNode.getNodeValue()))) continue;
            for (String code : codes = errorCodes.split(ERROR_CODE_DELIMITER)) {
                dict.addErrorCode(storeErrorTypes.get(errorType), code.trim());
            }
        }
    }

    static {
        storeErrorTypes.put("lock", 1);
        storeErrorTypes.put("object-exists", 5);
        storeErrorTypes.put("object-not-found", 2);
        storeErrorTypes.put("optimistic", 3);
        storeErrorTypes.put("referential-integrity", 4);
        _loc = Localizer.forPackage(SQLErrorCodeReader.class);
    }
}

