/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ValueListener;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Value
implements Cloneable {
    private static final String[] EMPTY_ALIASES = new String[0];
    private static final Localizer s_loc = Localizer.forPackage(Value.class);
    private String prop = null;
    private String loadKey = null;
    private String def = null;
    private String[] aliases = null;
    private String getter = null;
    private List<ValueListener> listeners = null;
    private boolean aliasListComprehensive = false;
    private Class scope = null;
    private boolean isDynamic = false;
    private String originalValue = null;

    public Value() {
    }

    public Value(String prop) {
        this.setProperty(prop);
    }

    public String getProperty() {
        return this.prop;
    }

    public void setProperty(String prop) {
        this.prop = prop;
    }

    public String getLoadKey() {
        return this.loadKey;
    }

    public void setLoadKey(String loadKey) {
        this.loadKey = loadKey;
    }

    public String[] getAliases() {
        return this.aliases == null ? EMPTY_ALIASES : this.aliases;
    }

    public void setAliases(String[] aliases) {
        String[] aStrings = new String[aliases.length];
        System.arraycopy(aliases, 0, aStrings, 0, aStrings.length);
        this.aliases = aStrings;
    }

    public void setAlias(String key, String value) {
        this.aliases = this.setAlias(key, value, this.aliases);
    }

    protected String[] setAlias(String key, String value, String[] aliases) {
        if (aliases == null) {
            aliases = EMPTY_ALIASES;
        }
        for (int i = 0; i < aliases.length; i += 2) {
            if (!key.equals(aliases[i])) continue;
            aliases[i + 1] = value;
            return aliases;
        }
        String[] newAliases = new String[aliases.length + 2];
        System.arraycopy(aliases, 0, newAliases, 2, aliases.length);
        newAliases[0] = key;
        newAliases[1] = value;
        return newAliases;
    }

    public boolean isAliasListComprehensive() {
        return this.aliasListComprehensive;
    }

    public void setAliasListComprehensive(boolean aliasListIsComprehensive) {
        this.aliasListComprehensive = aliasListIsComprehensive;
    }

    public String alias(String str) {
        return this.alias(str, this.aliases, false);
    }

    protected String alias(String str, String[] aliases, boolean nullNotFound) {
        if (str != null) {
            str = str.trim();
        }
        if (aliases == null || aliases.length == 0) {
            return nullNotFound ? null : str;
        }
        boolean empty = str != null && str.length() == 0;
        for (int i = 1; i < aliases.length; i += 2) {
            if (!StringUtils.equals((String)str, (String)aliases[i]) && (!empty || aliases[i] != null)) continue;
            return aliases[i - 1];
        }
        return nullNotFound ? null : str;
    }

    public String unalias(String str) {
        return this.unalias(str, this.aliases, false);
    }

    protected String unalias(String str, String[] aliases, boolean nullNotFound) {
        boolean empty;
        if (str != null) {
            str = str.trim();
        }
        boolean bl = empty = str != null && str.length() == 0;
        if (str == null || empty && this.def != null) {
            str = this.def;
        }
        if (aliases != null) {
            for (int i = 0; i < aliases.length; i += 2) {
                if (!StringUtils.equals((String)str, (String)aliases[i]) && !StringUtils.equals((String)str, (String)aliases[i + 1]) && (!empty || aliases[i] != null)) continue;
                return aliases[i + 1];
            }
        }
        if (this.isAliasListComprehensive() && aliases != null) {
            throw new ParseException(s_loc.get("invalid-enumerated-config", this.getProperty(), str, Arrays.asList(aliases)));
        }
        return nullNotFound ? null : str;
    }

    public String getDefault() {
        return this.def;
    }

    public void setDefault(String def) {
        this.def = def;
    }

    public String getInstantiatingGetter() {
        return this.getter;
    }

    public void setInstantiatingGetter(String getter) {
        this.getter = getter;
    }

    public Class getScope() {
        return this.scope;
    }

    public void setScope(Class cls) {
        this.scope = cls;
    }

    public String getString() {
        return this.alias(this.getInternalString());
    }

    public void setString(String val) {
        this.assertChangeable();
        String str = this.unalias(val);
        try {
            this.setInternalString(str);
            if (this.originalValue == null && val != null && !this.isDefault(val)) {
                this.originalValue = this.getString();
            }
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (RuntimeException re) {
            throw new ParseException(this.prop + ": " + val, (Throwable)re);
        }
    }

    public void setObject(Object obj) {
        if (obj == null && this.def != null) {
            this.setString(null);
        } else {
            try {
                this.setInternalObject(obj);
                if (this.originalValue == null && obj != null && !this.isDefault(obj)) {
                    this.originalValue = this.getString();
                }
            }
            catch (ParseException pe) {
                throw pe;
            }
            catch (RuntimeException re) {
                throw new ParseException(this.prop + ": " + obj, (Throwable)re);
            }
        }
    }

    public String getOriginalValue() {
        return this.originalValue == null ? this.getDefault() : this.originalValue;
    }

    boolean isDefault(Object val) {
        return val != null && val.toString().equals(this.getDefault());
    }

    public abstract Class getValueType();

    protected abstract String getInternalString();

    protected abstract void setInternalString(String var1);

    protected abstract void setInternalObject(Object var1);

    public List<ValueListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void addListener(ValueListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<ValueListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ValueListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void valueChanged() {
        if (this.listeners == null) {
            return;
        }
        for (ValueListener listener : this.listeners) {
            listener.valueChanged(this);
        }
    }

    protected void assertChangeable() {
        if (!this.isDynamic() && this.containsReadOnlyConfigurationAsListener()) {
            throw new RuntimeException(s_loc.get("veto-change", this.getProperty()).toString());
        }
    }

    boolean containsReadOnlyConfigurationAsListener() {
        if (this.listeners == null) {
            return false;
        }
        for (ValueListener listener : this.listeners) {
            if (!(listener instanceof Configuration) || !((Configuration)((Object)listener)).isReadOnly()) continue;
            return true;
        }
        return false;
    }

    public void setDynamic(boolean flag) {
        this.isDynamic = flag;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public int hashCode() {
        String str = this.isDynamic() ? this.getOriginalValue() : this.getString();
        int strHash = str == null ? 0 : str.hashCode();
        int propHash = this.prop == null ? 0 : this.prop.hashCode();
        return strHash ^ propHash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Value)) {
            return false;
        }
        Value o = (Value)other;
        String thisStr = this.isDynamic() ? this.getOriginalValue() : this.getString();
        String thatStr = this.isDynamic() ? o.getOriginalValue() : o.getString();
        return this.isDynamic() == o.isDynamic() && StringUtils.equals((String)this.prop, (String)o.getProperty()) && StringUtils.equals((String)thisStr, (String)thatStr);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }
}

