/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.replayer;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.replayer.RemainingExchangesException;
import org.apache.ode.bpel.engine.replayer.ReplayerContext;
import org.apache.ode.bpel.engine.replayer.ReplayerScheduler;
import org.apache.ode.bpel.iapi.BpelEngine;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.pmapi.CommunicationType;
import org.apache.ode.bpel.pmapi.ExchangeType;
import org.apache.ode.bpel.pmapi.FaultType;
import org.apache.ode.bpel.pmapi.GetCommunication;
import org.apache.ode.bpel.pmapi.GetCommunicationResponse;
import org.apache.ode.bpel.pmapi.Replay;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Replayer {
    private static final Log __log = LogFactory.getLog(Replayer.class);
    public ReplayerScheduler scheduler = new ReplayerScheduler();

    public List<Long> replayInstances(Replay request, BpelEngine engine, BpelDAOConnection conn) throws Exception {
        Date startDate = Calendar.getInstance().getTime();
        ArrayList<ReplayerContext> contexts = new ArrayList<ReplayerContext>();
        ArrayList<Long> toDelete = new ArrayList<Long>();
        ArrayList<CommunicationType> toRestore = new ArrayList<CommunicationType>();
        toDelete.addAll(request.getReplaceInstanceList());
        for (Long iid : request.getUpgradeInstanceList()) {
            toDelete.add(iid);
            toRestore.add(CommunicationType.Factory.parse((String)this.getCommunication(iid, conn).toString()));
        }
        toRestore.addAll(request.getRestoreInstanceList());
        HashSet<ProcessConf.CLEANUP_CATEGORY> cleanupCategory = new HashSet<ProcessConf.CLEANUP_CATEGORY>();
        cleanupCategory.add(ProcessConf.CLEANUP_CATEGORY.INSTANCE);
        cleanupCategory.add(ProcessConf.CLEANUP_CATEGORY.MESSAGES);
        cleanupCategory.add(ProcessConf.CLEANUP_CATEGORY.VARIABLES);
        cleanupCategory.add(ProcessConf.CLEANUP_CATEGORY.CORRELATIONS);
        cleanupCategory.add(ProcessConf.CLEANUP_CATEGORY.EVENTS);
        for (Long l : toDelete) {
            conn.getInstance(l).delete(cleanupCategory);
        }
        for (CommunicationType r : toRestore) {
            ReplayerContext context = new ReplayerContext(startDate);
            context.bpelEngine = (BpelEngineImpl)engine;
            context.init(r, this.scheduler);
            contexts.add(context);
        }
        this.scheduler.startReplaying();
        ArrayList<CommunicationType.Exchange> remainingExchanges = new ArrayList<CommunicationType.Exchange>();
        for (ReplayerContext c : contexts) {
            c.answers.remainingExchanges(remainingExchanges);
        }
        if (remainingExchanges.size() > 0) {
            throw new RemainingExchangesException(remainingExchanges);
        }
        ArrayList<Long> r = new ArrayList<Long>();
        for (ReplayerContext c : contexts) {
            r.add(c.runtimeContext.getPid());
        }
        return r;
    }

    public GetCommunicationResponse getCommunication(GetCommunication request, BpelDAOConnection conn) throws Exception {
        GetCommunicationResponse response = GetCommunicationResponse.Factory.newInstance();
        for (Long iid : request.getIidList()) {
            response.addNewRestoreInstance().set((XmlObject)this.getCommunication(iid, conn));
        }
        return response;
    }

    private CommunicationType getCommunication(Long iid, BpelDAOConnection conn) {
        CommunicationType result = CommunicationType.Factory.newInstance();
        ArrayList<CommunicationType.Exchange> list = new ArrayList<CommunicationType.Exchange>();
        ProcessInstanceDAO instance = conn.getInstance(iid);
        if (instance == null) {
            return result;
        }
        result.setProcessType(instance.getProcess().getType());
        for (String mexId : instance.getMessageExchangeIds()) {
            MessageExchangeDAO mexDao = conn.getMessageExchange(mexId);
            CommunicationType.Exchange e = CommunicationType.Exchange.Factory.newInstance();
            list.add(e);
            e.setCreateTime((Calendar)new XmlCalendar(mexDao.getCreateTime()));
            e.setOperation(mexDao.getOperation());
            try {
                e.setIn(XmlObject.Factory.parse((Node)mexDao.getRequest().getData()));
            }
            catch (XmlException e1) {
                __log.error((Object)"", (Throwable)e1);
            }
            try {
                MessageExchange.Status status = MessageExchange.Status.valueOf((String)mexDao.getStatus());
                if (status == MessageExchange.Status.FAULT) {
                    FaultType f = e.addNewFault();
                    f.setType(mexDao.getFault());
                    f.setExplanation(mexDao.getFaultExplanation());
                    if (mexDao.getResponse() != null) {
                        f.setMessage(XmlObject.Factory.parse((Node)mexDao.getResponse().getData()));
                    }
                } else if (status == MessageExchange.Status.FAILURE) {
                    e.addNewFailure().setExplanation(mexDao.getFaultExplanation());
                } else if (mexDao.getResponse() != null) {
                    e.setOut(XmlObject.Factory.parse((Node)mexDao.getResponse().getData()));
                }
            }
            catch (XmlException e1) {
                __log.error((Object)"", (Throwable)e1);
            }
            e.setType(ExchangeType.Enum.forString((String)("" + mexDao.getDirection())));
            __log.debug((Object)"---");
            __log.debug((Object)("" + mexDao.getCallee()));
            __log.debug((Object)("" + mexDao.getChannel()));
            __log.debug((Object)("" + mexDao.getCreateTime()));
            __log.debug((Object)("" + mexDao.getEPR()));
            __log.debug((Object)("" + mexDao.getPortType()));
            if (e.getType() == ExchangeType.P) {
                e.setService(mexDao.getPortType());
                continue;
            }
            e.setService(mexDao.getCallee());
        }
        Collections.sort(list, new Comparator<CommunicationType.Exchange>(){

            @Override
            public int compare(CommunicationType.Exchange arg0, CommunicationType.Exchange arg1) {
                return arg0.getCreateTime().compareTo(arg1.getCreateTime());
            }
        });
        for (CommunicationType.Exchange e : list) {
            result.addNewExchange().set((XmlObject)e);
        }
        return result;
    }
}

