/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.replayer;

import java.util.Date;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.replayer.ReplayerBpelRuntimeContextImpl;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Scheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayerScheduler
implements Scheduler {
    private static final Log __log = LogFactory.getLog(ReplayerScheduler.class);
    private PriorityQueue<TaskElement> taskQueue = new PriorityQueue();

    public void scheduleReplayerJob(Callable action, Date when, ReplayerBpelRuntimeContextImpl runtimeContext) {
        this.taskQueue.add(new TaskElement(when, action, runtimeContext));
    }

    public void cancelJob(String jobId) throws ContextException {
        throw new IllegalStateException();
    }

    public <T> T execTransaction(Callable<T> transaction) throws Exception, ContextException {
        throw new IllegalStateException();
    }

    public <T> T execTransaction(Callable<T> transaction, int timeout) throws Exception, ContextException {
        throw new IllegalStateException();
    }

    public boolean isTransacted() {
        return true;
    }

    public void registerSynchronizer(Scheduler.Synchronizer synch) throws ContextException {
        throw new IllegalStateException();
    }

    public void setJobProcessor(Scheduler.JobProcessor processor) throws ContextException {
        throw new IllegalStateException();
    }

    public void setRollbackOnly() throws Exception {
        throw new IllegalStateException();
    }

    public void shutdown() {
    }

    public void startReplaying() throws Exception {
        while (!this.taskQueue.isEmpty()) {
            TaskElement taskElement = (TaskElement)this.taskQueue.remove();
            __log.debug((Object)("executing action at time " + taskElement.when));
            if (taskElement.runtimeContext != null) {
                taskElement.runtimeContext.setCurrentEventDateTime(taskElement.when);
            }
            taskElement.action.call();
        }
    }

    public void stop() {
    }

    public void start() {
    }

    public <T> Future<T> execIsolatedTransaction(Callable<T> transaction) throws Exception, ContextException {
        return null;
    }

    public String scheduleMapSerializableRunnable(Scheduler.MapSerializableRunnable runnable, Date when) throws ContextException {
        return null;
    }

    public String schedulePersistedJob(Map<String, Object> jobDetail, Date when) throws ContextException {
        return null;
    }

    public String scheduleVolatileJob(boolean transacted, Map<String, Object> jobDetail, Date when) throws ContextException {
        return null;
    }

    public String scheduleVolatileJob(boolean transacted, Map<String, Object> jobDetail) throws ContextException {
        return null;
    }

    public void setPolledRunnableProcesser(Scheduler.JobProcessor polledRunnableProcessor) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskElement
    implements Comparable<TaskElement> {
        public final Date when;
        public final Callable<Object> action;
        public final ReplayerBpelRuntimeContextImpl runtimeContext;

        public TaskElement(Date when, Callable<Object> action, ReplayerBpelRuntimeContextImpl runtimeContext) {
            this.when = when;
            this.action = action;
            this.runtimeContext = runtimeContext;
        }

        @Override
        public int compareTo(TaskElement o) {
            return this.when.compareTo(o.when);
        }
    }
}

