/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OEventHandler;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.ExprEvaluationContextImpl;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.channels.EventHandlerControlChannel;
import org.apache.ode.bpel.runtime.channels.EventHandlerControlChannelListener;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannel;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.runtime.channels.TerminationChannel;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.bpel.runtime.channels.TimerResponseChannel;
import org.apache.ode.bpel.runtime.channels.TimerResponseChannelListener;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;

class EH_ALARM
extends BpelJacobRunnable {
    private static final Log __log = LogFactory.getLog(EH_ALARM.class);
    private static final long serialVersionUID = 1L;
    private ParentScopeChannel _psc;
    private TerminationChannel _tc;
    private OEventHandler.OAlarm _oalarm;
    private ScopeFrame _scopeFrame;
    private EventHandlerControlChannel _cc;
    private Set<CompensationHandler> _comps = new HashSet<CompensationHandler>();

    EH_ALARM(ParentScopeChannel psc, TerminationChannel tc, EventHandlerControlChannel cc, OEventHandler.OAlarm o, ScopeFrame scopeFrame) {
        this._psc = psc;
        this._tc = tc;
        this._cc = cc;
        this._scopeFrame = scopeFrame;
        this._oalarm = o;
    }

    public void run() {
        Calendar alarm = Calendar.getInstance();
        if (this._oalarm.forExpr != null) {
            try {
                this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsDuration(this._oalarm.forExpr, this.getEvaluationContext()).addTo(alarm);
            }
            catch (EvaluationException e) {
                throw new InvalidProcessException((Exception)((Object)e));
            }
            catch (FaultException e) {
                __log.error((Object)e);
                this._psc.completed(this.createFault(e.getQName(), (OBase)this._oalarm.forExpr), this._comps);
                return;
            }
        }
        if (this._oalarm.untilExpr != null) {
            try {
                alarm.setTime(this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsDate(this._oalarm.untilExpr, this.getEvaluationContext()).getTime());
            }
            catch (EvaluationException e) {
                throw new InvalidProcessException((Exception)((Object)e));
            }
            catch (FaultException e) {
                __log.error((Object)e);
                this._psc.completed(this.createFault(e.getQName(), (OBase)this._oalarm.untilExpr), this._comps);
                return;
            }
        }
        EH_ALARM.instance((JacobRunnable)new WAIT(alarm));
    }

    protected EvaluationContext getEvaluationContext() {
        return new ExprEvaluationContextImpl(this._scopeFrame, this.getBpelRuntimeContext());
    }

    private class ACTIVE
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -2166253425722769701L;
        private ActivityInfo _activity;
        private boolean _stopped = false;

        ACTIVE(ActivityInfo activity) {
            this._activity = activity;
        }

        public void run() {
            ACTIVE.object((boolean)false, (Set)new ParentScopeChannelListener(this._activity.parent){
                private static final long serialVersionUID = -3357030137175178040L;

                @Override
                public void compensate(OScope scope, SynchChannel ret) {
                    EH_ALARM.this._psc.compensate(scope, ret);
                    3.instance((JacobRunnable)ACTIVE.this);
                }

                @Override
                public void completed(FaultData faultData, Set<CompensationHandler> compensations) {
                    EH_ALARM.this._comps.addAll(compensations);
                    if (!ACTIVE.this._stopped && ((EH_ALARM)EH_ALARM.this)._oalarm.repeatExpr != null) {
                        Calendar next = Calendar.getInstance();
                        try {
                            ACTIVE.this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsDuration(((EH_ALARM)EH_ALARM.this)._oalarm.repeatExpr, EH_ALARM.this.getEvaluationContext()).addTo(next);
                        }
                        catch (EvaluationException e) {
                            throw new InvalidProcessException((Exception)((Object)e));
                        }
                        catch (FaultException e) {
                            __log.error((Object)e);
                            EH_ALARM.this._psc.completed(ACTIVE.this.createFault(e.getQName(), (OBase)((EH_ALARM)EH_ALARM.this)._oalarm.forExpr), EH_ALARM.this._comps);
                            return;
                        }
                        3.instance((JacobRunnable)new WAIT(next));
                    } else if (faultData != null) {
                        EH_ALARM.this._psc.completed(faultData, EH_ALARM.this._comps);
                    } else {
                        3.instance((JacobRunnable)new WAIT(null));
                    }
                }

                @Override
                public void cancelled() {
                    this.completed(null, CompensationHandler.emptySet());
                }

                @Override
                public void failure(String reason, Element data) {
                    this.completed(null, CompensationHandler.emptySet());
                }
            }.or(new EventHandlerControlChannelListener(EH_ALARM.this._cc){
                private static final long serialVersionUID = -3873619538789039424L;

                public void stop() {
                    ACTIVE.this._stopped = true;
                    2.instance((JacobRunnable)ACTIVE.this);
                }
            }.or(new TerminationChannelListener(EH_ALARM.this._tc){
                private static final long serialVersionUID = -4566956567870652885L;

                public void terminate() {
                    ((TerminationChannel)1.replication((Channel)((ACTIVE)ACTIVE.this)._activity.self)).terminate();
                    ACTIVE.this._stopped = true;
                    1.instance((JacobRunnable)ACTIVE.this);
                }
            })));
        }
    }

    private class FIRE
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -7261315204412433250L;

        private FIRE() {
        }

        public void run() {
            ActivityInfo child = new ActivityInfo(this.genMonotonic(), ((EH_ALARM)EH_ALARM.this)._oalarm.activity, (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
            FIRE.instance((JacobRunnable)this.createChild(child, EH_ALARM.this._scopeFrame, new LinkFrame(null)));
            FIRE.instance((JacobRunnable)new ACTIVE(child));
        }
    }

    private class WAIT
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -1426724996925898213L;
        Calendar _alarm;

        WAIT(Calendar alarm) {
            this._alarm = alarm;
        }

        public void run() {
            Calendar now = Calendar.getInstance();
            Set listeners = new EventHandlerControlChannelListener(EH_ALARM.this._cc){
                private static final long serialVersionUID = -7750428941445331236L;

                public void stop() {
                    EH_ALARM.this._psc.completed(null, EH_ALARM.this._comps);
                }
            }.or(new TerminationChannelListener(EH_ALARM.this._tc){
                private static final long serialVersionUID = 6100105997983514609L;

                public void terminate() {
                    EH_ALARM.this._psc.completed(null, EH_ALARM.this._comps);
                }
            });
            if (this._alarm == null) {
                WAIT.object((boolean)false, (Set)listeners);
            } else if (now.before(this._alarm)) {
                TimerResponseChannel trc = (TimerResponseChannel)this.newChannel(TimerResponseChannel.class);
                this.getBpelRuntimeContext().registerTimer(trc, this._alarm.getTime());
                listeners.add(new TimerResponseChannelListener(trc){
                    private static final long serialVersionUID = 1110683632756756017L;

                    public void onTimeout() {
                        3.instance((JacobRunnable)new FIRE());
                    }

                    public void onCancel() {
                        EH_ALARM.this._psc.completed(null, EH_ALARM.this._comps);
                    }
                });
                WAIT.object((boolean)false, (Set)listeners);
            } else {
                ActivityInfo child = new ActivityInfo(this.genMonotonic(), ((EH_ALARM)EH_ALARM.this)._oalarm.activity, (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
                WAIT.instance((JacobRunnable)this.createChild(child, EH_ALARM.this._scopeFrame, new LinkFrame(null)));
                WAIT.instance((JacobRunnable)new ACTIVE(child));
            }
        }
    }
}

