/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.daohib.bpel.hobj.HActivityRecovery;
import org.apache.ode.daohib.bpel.hobj.HBpelEvent;
import org.apache.ode.daohib.bpel.hobj.HCorrelationProperty;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;
import org.apache.ode.daohib.bpel.hobj.HCorrelator;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorMessage;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorSelector;
import org.apache.ode.daohib.bpel.hobj.HFaultData;
import org.apache.ode.daohib.bpel.hobj.HMessage;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HMessageExchangeProperty;
import org.apache.ode.daohib.bpel.hobj.HPartnerLink;
import org.apache.ode.daohib.bpel.hobj.HProcess;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.daohib.bpel.hobj.HScope;
import org.apache.ode.daohib.bpel.hobj.HVariableProperty;
import org.apache.ode.daohib.bpel.hobj.HXmlData;
import org.apache.ode.utils.uuid.UUID;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class SessionManager {
    private static final Log __log = LogFactory.getLog(SessionManager.class);
    public static final String PROP_GUID = "ode.hibernate.guid";
    private static final Map<String, TransactionManager> _txManagers = Collections.synchronizedMap(new HashMap());
    private static final Map<String, DataSource> _dataSources = Collections.synchronizedMap(new HashMap());
    private static final String[] CANNOT_JOIN_FOR_UPDATE_DIALECTS = new String[]{"org.hibernate.dialect.IngresDialect"};
    private final String _uuid = new UUID().toString();
    private final TransactionManager _txManager;
    private final SessionFactory _sessionFactory;
    private boolean _canJoinForUpdate = true;

    public SessionManager(Properties env, DataSource ds, TransactionManager tx) throws HibernateException {
        if (tx == null) {
            throw new IllegalArgumentException("Null transaction manager");
        }
        this._txManager = tx;
        _txManagers.put(this._uuid, tx);
        _dataSources.put(this._uuid, ds);
        this._sessionFactory = this.getDefaultConfiguration().setProperties(env).setProperty(PROP_GUID, this._uuid).buildSessionFactory();
        String currentHibDialect = env.getProperty("hibernate.dialect");
        for (String dialect : CANNOT_JOIN_FOR_UPDATE_DIALECTS) {
            if (!dialect.equals(currentHibDialect)) continue;
            this._canJoinForUpdate = false;
        }
    }

    TransactionManager getTransactionManager() {
        return this._txManager;
    }

    public static void registerTransactionManager(String uuid, TransactionManager txm) {
        _txManagers.put(uuid, txm);
    }

    public Session getSession() {
        return this._sessionFactory.getCurrentSession();
    }

    public boolean canJoinForUpdate() {
        return this._canJoinForUpdate;
    }

    public Configuration getDefaultConfiguration() throws MappingException {
        return new Configuration().addClass(HProcess.class).addClass(HProcessInstance.class).addClass(HCorrelator.class).addClass(HCorrelatorMessage.class).addClass(HCorrelationProperty.class).addClass(HCorrelatorSelector.class).addClass(HMessageExchange.class).addClass(HMessage.class).addClass(HPartnerLink.class).addClass(HScope.class).addClass(HCorrelationSet.class).addClass(HXmlData.class).addClass(HVariableProperty.class).addClass(HBpelEvent.class).addClass(HFaultData.class).addClass(HActivityRecovery.class).addClass(HMessageExchangeProperty.class);
    }

    public static TransactionManager getTransactionManager(Properties props) {
        String guid = props.getProperty(PROP_GUID);
        return _txManagers.get(guid);
    }

    public static Connection getConnection(Properties props) throws SQLException {
        String guid = props.getProperty(PROP_GUID);
        return _dataSources.get(guid).getConnection();
    }
}

