/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.CorrelatorMessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.CorrelatorMessageDaoImpl;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.MessageExchangeDaoImpl;
import org.apache.ode.daohib.bpel.MessageRouteDaoImpl;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HCorrelator;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorMessage;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorSelector;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CorrelatorDaoImpl
extends HibernateDao
implements CorrelatorDAO {
    static Log __log = LogFactory.getLog(CorrelatorDaoImpl.class);
    private static final String LOCK_SELECTORS = "update from HCorrelatorSelector as hs set hs.lock = hs.lock+1 where hs.processType = :processType";
    private static final String FLTR_SELECTORS = "from HCorrelatorSelector as hs where hs.processType = :processType and hs.correlator.correlatorId = :correlatorId";
    private static final String FLTR_SELECTORS_SUBQUERY = "from HCorrelatorSelector as hs where hs.processType = :processType and hs.correlatorId = (select hc.id from HCorrelator as hc where hc.correlatorId = :correlatorId )".intern();
    private static final String QRY_DELSELECTORS = "delete from HCorrelatorSelector where groupId = ? and instance = ?";
    private HCorrelator _hobj;

    public CorrelatorDaoImpl(SessionManager sm, HCorrelator hobj) {
        super(sm, hobj);
        this.entering("CorrelatorDaoImpl.CorrelatorDaoImpl");
        this._hobj = hobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageExchangeDAO dequeueMessage(CorrelationKeySet keySet) {
        this.entering("CorrelatorDaoImpl.dequeueMessage");
        MessageExchangeDaoImpl mex = null;
        String hdr = "dequeueMessage(" + keySet + "): ";
        __log.debug((Object)hdr);
        List subSets = keySet.findSubSets();
        Query qry = this.getSession().createFilter(this._hobj.getMessageCorrelations(), this.generateUnmatchedQuery(subSets));
        for (int i = 0; i < subSets.size(); ++i) {
            qry.setString("s" + i, ((CorrelationKeySet)subSets.get(i)).toCanonicalString());
        }
        Iterator mcors = qry.iterate();
        try {
            if (!mcors.hasNext()) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(hdr + "did not find a MESSAGE entry."));
                }
            } else {
                HCorrelatorMessage mcor = (HCorrelatorMessage)mcors.next();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(hdr + "found MESSAGE entry " + mcor.getMessageExchange()));
                }
                mex = new MessageExchangeDaoImpl(this._sm, mcor.getMessageExchange());
            }
        }
        finally {
            Hibernate.close((Iterator)mcors);
        }
        return mex;
    }

    public List<MessageRouteDAO> findRoute(CorrelationKeySet keySet) {
        ArrayList<MessageRouteDAO> routes = new ArrayList<MessageRouteDAO>();
        this.entering("CorrelatorDaoImpl.findRoute");
        String hdr = "findRoute(keySet=" + keySet + "): ";
        if (__log.isDebugEnabled()) {
            __log.debug((Object)hdr);
        }
        String processType = new QName(this._hobj.getProcess().getTypeNamespace(), this._hobj.getProcess().getTypeName()).toString();
        List subSets = keySet.findSubSets();
        Query q = this.getSession().createQuery(this.generateSelectorQuery(this._sm.canJoinForUpdate() ? FLTR_SELECTORS : FLTR_SELECTORS_SUBQUERY, subSets));
        q.setString("processType", processType);
        q.setString("correlatorId", this._hobj.getCorrelatorId());
        for (int i = 0; i < subSets.size(); ++i) {
            q.setString("s" + i, ((CorrelationKeySet)subSets.get(i)).toCanonicalString());
        }
        q.setLockMode("hs", LockMode.UPGRADE);
        ArrayList<HProcessInstance> targets = new ArrayList<HProcessInstance>();
        for (HCorrelatorSelector selector : q.list()) {
            boolean isRoutePolicyOne;
            if (selector == null) continue;
            boolean bl = isRoutePolicyOne = selector.getRoute() == null || "one".equals(selector.getRoute());
            if (!"all".equals(selector.getRoute()) && (!isRoutePolicyOne || targets.contains(selector.getInstance()))) continue;
            routes.add(new MessageRouteDaoImpl(this._sm, selector));
            targets.add(selector.getInstance());
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(hdr + "found " + routes));
        }
        return routes;
    }

    private String generateUnmatchedQuery(List<CorrelationKeySet> subSets) {
        StringBuffer filterQuery = new StringBuffer();
        if (subSets.size() == 1) {
            filterQuery.append(" where this.correlationKey = :s0");
        } else if (subSets.size() > 1) {
            filterQuery.append(" where this.correlationKey in(");
            for (int i = 0; i < subSets.size(); ++i) {
                if (i > 0) {
                    filterQuery.append(", ");
                }
                filterQuery.append(":s").append(i);
            }
            filterQuery.append(")");
        }
        return filterQuery.toString();
    }

    private String generateSelectorQuery(String header, List<CorrelationKeySet> subSets) {
        StringBuffer filterQuery = new StringBuffer(header);
        if (subSets.size() == 1) {
            filterQuery.append(" and hs.correlationKey = :s0");
        } else if (subSets.size() > 1) {
            filterQuery.append(" and hs.correlationKey in(");
            for (int i = 0; i < subSets.size(); ++i) {
                if (i > 0) {
                    filterQuery.append(", ");
                }
                filterQuery.append(":s").append(i);
            }
            filterQuery.append(")");
        }
        return filterQuery.toString();
    }

    public void enqueueMessage(MessageExchangeDAO mex, CorrelationKeySet correlationKeySet) {
        this.entering("CorrelatorDaoImpl.enqueueMessage");
        String hdr = "enqueueMessage(mex=" + ((MessageExchangeDaoImpl)mex)._hobj.getId() + " keySet=" + correlationKeySet.toCanonicalString() + "): ";
        if (__log.isDebugEnabled()) {
            __log.debug((Object)hdr);
        }
        for (CorrelationKeySet aSubSet : correlationKeySet.findSubSets()) {
            HCorrelatorMessage mcor = new HCorrelatorMessage();
            mcor.setCorrelator(this._hobj);
            mcor.setCreated(new Date());
            mcor.setMessageExchange((HMessageExchange)((MessageExchangeDaoImpl)mex)._hobj);
            mcor.setCorrelationKey(aSubSet.toCanonicalString());
            this.getSession().save((Object)mcor);
            if (!__log.isDebugEnabled()) continue;
            __log.debug((Object)(hdr + "saved " + mcor));
        }
    }

    public void addRoute(String routeGroupId, ProcessInstanceDAO target, int idx, CorrelationKeySet correlationKeySet, String routePolicy) {
        this.entering("CorrelatorDaoImpl.addRoute");
        String hdr = "addRoute(" + routeGroupId + ", iid=" + target.getInstanceId() + ", idx=" + idx + ", ckeySet=" + correlationKeySet + "): ";
        if (__log.isDebugEnabled()) {
            __log.debug((Object)hdr);
        }
        HCorrelatorSelector hsel = new HCorrelatorSelector();
        hsel.setGroupId(routeGroupId);
        hsel.setIndex(idx);
        hsel.setLock(0);
        hsel.setCorrelationKey(correlationKeySet.toCanonicalString());
        hsel.setInstance((HProcessInstance)((ProcessInstanceDaoImpl)target).getHibernateObj());
        hsel.setProcessType(target.getProcess().getType().toString());
        hsel.setCorrelator(this._hobj);
        hsel.setCreated(new Date());
        hsel.setRoute(routePolicy);
        this.getSession().save((Object)hsel);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(hdr + "saved " + hsel));
        }
    }

    public boolean checkRoute(CorrelationKey ckey) {
        this.entering("CorrelatorDaoImpl.checkRoute");
        Query lockQry = this.getSession().createQuery(LOCK_SELECTORS);
        lockQry.setString("ckey", ckey == null ? null : ckey.toCanonicalString());
        lockQry.setEntity("corr", (Object)this._hobj);
        lockQry.setReadOnly(true);
        return lockQry.list().isEmpty();
    }

    public String getCorrelatorId() {
        return this._hobj.getCorrelatorId();
    }

    public void setCorrelatorId(String newId) {
        this._hobj.setCorrelatorId(newId);
    }

    public void removeRoutes(String routeGroupId, ProcessInstanceDAO target) {
        this.entering("CorrelatorDaoImpl.removeRoutes");
        String hdr = "removeRoutes(" + routeGroupId + ", iid=" + target.getInstanceId() + "): ";
        __log.debug((Object)hdr);
        Session session = this.getSession();
        Query q = session.createQuery(QRY_DELSELECTORS);
        q.setString(0, routeGroupId);
        q.setEntity(1, (Object)((ProcessInstanceDaoImpl)target).getHibernateObj());
        int updates = q.executeUpdate();
        session.flush();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(hdr + "deleted " + updates + " rows"));
        }
    }

    public Collection<CorrelatorMessageDAO> getAllMessages() {
        ArrayList<CorrelatorMessageDAO> msgs = new ArrayList<CorrelatorMessageDAO>();
        for (HCorrelatorMessage correlatorMessage : this._hobj.getMessageCorrelations()) {
            msgs.add(new CorrelatorMessageDaoImpl(this._sm, correlatorMessage));
        }
        return msgs;
    }

    public Collection<MessageRouteDAO> getAllRoutes() {
        ArrayList<MessageRouteDAO> routes = new ArrayList<MessageRouteDAO>();
        for (HCorrelatorSelector selector : this._hobj.getSelectors()) {
            routes.add(new MessageRouteDaoImpl(this._sm, selector));
        }
        return routes;
    }
}

