/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.RelativeDateParser;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

class CriteriaBuilder {
    CriteriaBuilder() {
    }

    void buildCriteria(Criteria crit, InstanceFilter filter) {
        List iids;
        Criteria processCrit = crit.createCriteria("process");
        List pids = filter.getPidFilter();
        if (pids != null && pids.size() > 0) {
            Disjunction disj = Restrictions.disjunction();
            for (String pid : pids) {
                if (!filter.arePidsNegative()) {
                    disj.add((Criterion)Restrictions.eq((String)"processId", (Object)pid));
                    continue;
                }
                disj.add((Criterion)Restrictions.ne((String)"processId", (Object)pid));
            }
            processCrit.add((Criterion)disj);
        }
        if ((iids = filter.getIidFilter()) != null && iids.size() > 0) {
            Disjunction disj = Restrictions.disjunction();
            for (String string : iids) {
                disj.add((Criterion)Restrictions.eq((String)"id", (Object)new Long(string)));
            }
            crit.add((Criterion)disj);
        }
        if (filter.getNameFilter() != null) {
            processCrit.add((Criterion)Restrictions.like((String)"typeName", (Object)filter.getNameFilter().replaceAll("\\*", "%")));
        }
        if (filter.getNamespaceFilter() != null) {
            processCrit.add((Criterion)Restrictions.like((String)"typeNamespace", (Object)filter.getNamespaceFilter().replaceAll("\\*", "%")));
        }
        if (filter.getStatusFilter() != null) {
            List statuses = filter.convertFilterState();
            Disjunction disj = Restrictions.disjunction();
            Iterator iterator = statuses.iterator();
            while (iterator.hasNext()) {
                short status = (Short)iterator.next();
                disj.add((Criterion)Restrictions.eq((String)"state", (Object)status));
            }
            crit.add((Criterion)disj);
        }
        if (filter.getStartedDateFilter() != null) {
            for (String sdf : filter.getStartedDateFilter()) {
                CriteriaBuilder.addFilterOnPrefixedDate(crit, sdf, "created");
            }
        }
        if (filter.getLastActiveDateFilter() != null) {
            for (String ladf : filter.getLastActiveDateFilter()) {
                CriteriaBuilder.addFilterOnPrefixedDate(crit, ladf, "lastActiveTime");
            }
        }
        if (filter.getPropertyValuesFilter() != null) {
            Criteria propCrit = crit.createCriteria("correlationSets").createCriteria("properties");
            for (Map.Entry entry : filter.getPropertyValuesFilter().entrySet()) {
                String propName = (String)entry.getKey();
                if (propName.startsWith("{")) {
                    String namespace = propName.substring(1, propName.lastIndexOf("}"));
                    propName = propName.substring(propName.lastIndexOf("}") + 1, propName.length());
                    propCrit.add((Criterion)Restrictions.eq((String)"name", (Object)propName)).add((Criterion)Restrictions.eq((String)"namespace", (Object)namespace)).add((Criterion)Restrictions.eq((String)"value", entry.getValue()));
                    continue;
                }
                propCrit.add((Criterion)Restrictions.eq((String)"name", entry.getKey())).add((Criterion)Restrictions.eq((String)"value", entry.getValue()));
            }
        }
        if (filter.orders != null) {
            for (String key : filter.orders) {
                boolean bl;
                boolean bl2 = true;
                String orderKey = key;
                if (key.startsWith("+") || key.startsWith("-")) {
                    orderKey = key.substring(1, key.length());
                    if (key.startsWith("-")) {
                        bl = false;
                    }
                }
                if ("name".equals(orderKey)) {
                    if (bl) {
                        processCrit.addOrder(Property.forName((String)"typeName").asc());
                        continue;
                    }
                    processCrit.addOrder(Property.forName((String)"typeName").desc());
                    continue;
                }
                if ("namespace".equals(orderKey)) {
                    if (bl) {
                        processCrit.addOrder(Property.forName((String)"typeNamespace").asc());
                        continue;
                    }
                    processCrit.addOrder(Property.forName((String)"typeNamespace").desc());
                    continue;
                }
                if ("pid".equals(orderKey)) {
                    if (bl) {
                        processCrit.addOrder(Property.forName((String)"processId").asc());
                        continue;
                    }
                    processCrit.addOrder(Property.forName((String)"processId").desc());
                    continue;
                }
                if ("version".equals(orderKey)) {
                    if (bl) {
                        processCrit.addOrder(Property.forName((String)"version").asc());
                        continue;
                    }
                    processCrit.addOrder(Property.forName((String)"version").desc());
                    continue;
                }
                if ("status".equals(orderKey)) {
                    if (bl) {
                        crit.addOrder(Property.forName((String)"state").asc());
                        continue;
                    }
                    crit.addOrder(Property.forName((String)"state").desc());
                    continue;
                }
                if ("started".equals(orderKey)) {
                    if (bl) {
                        crit.addOrder(Property.forName((String)"created").asc());
                        continue;
                    }
                    crit.addOrder(Property.forName((String)"created").desc());
                    continue;
                }
                if (!"last-active".equals(orderKey)) continue;
                if (bl) {
                    crit.addOrder(Property.forName((String)"lastActiveTime").asc());
                    continue;
                }
                crit.addOrder(Property.forName((String)"lastActiveTime").desc());
            }
        }
        if (filter.getLimit() > 0) {
            crit.setMaxResults(filter.getLimit());
        }
    }

    void buildCriteria(Criteria crit, BpelEventFilter efilter) {
        if (efilter.getTypeFilter() != null) {
            crit.add((Criterion)Restrictions.like((String)"type", (Object)efilter.getTypeFilter().replace('*', '%')));
        }
        if (efilter.getTimestampFilter() != null) {
            for (Filter.Restriction sdf : efilter.getTimestampFilter()) {
                CriteriaBuilder.addFilterOnPrefixedDate(crit, sdf.op, (Date)sdf.value, "tstamp");
            }
        }
        if (efilter.limit > 0) {
            crit.setMaxResults(efilter.limit);
        }
    }

    void addScopeFilter(Criteria crit, String scopeId) {
        crit.add((Criterion)Restrictions.eq((String)"", (Object)scopeId));
    }

    static void addFilterOnPrefixedDate(Criteria crit, String prefixedDate, String dateAttribute) {
        Date realDate = null;
        try {
            realDate = CriteriaBuilder.parseDateExpression(CriteriaBuilder.getDateWithoutOp(prefixedDate));
        }
        catch (ParseException e) {
            // empty catch block
        }
        CriteriaBuilder.addFilterOnPrefixedDate(crit, prefixedDate, realDate, dateAttribute);
    }

    private static Date parseDateExpression(String date) throws ParseException {
        if (date.toLowerCase().startsWith("-") && date.length() > 1) {
            return RelativeDateParser.parseRelativeDate((String)date.substring(1));
        }
        return ISO8601DateParser.parse((String)date);
    }

    static void addFilterOnPrefixedDate(Criteria crit, String op, Date date, String dateAttribute) {
        if (op.startsWith("=")) {
            crit.add((Criterion)Restrictions.eq((String)dateAttribute, (Object)date));
        } else if (op.startsWith("<=")) {
            crit.add((Criterion)Restrictions.le((String)dateAttribute, (Object)date));
        } else if (op.startsWith(">=")) {
            crit.add((Criterion)Restrictions.ge((String)dateAttribute, (Object)date));
        } else if (op.startsWith("<")) {
            crit.add((Criterion)Restrictions.lt((String)dateAttribute, (Object)date));
        } else if (op.startsWith(">")) {
            crit.add((Criterion)Restrictions.gt((String)dateAttribute, (Object)date));
        }
    }

    private static String getDateWithoutOp(String ddf) {
        return Filter.getDateWithoutOp((String)ddf);
    }
}

