/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.ScopeStateEnum;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.CorrelationSetDaoImpl;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.PartnerLinkDAOImpl;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.XmlDataDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HBpelEvent;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;
import org.apache.ode.daohib.bpel.hobj.HPartnerLink;
import org.apache.ode.daohib.bpel.hobj.HScope;
import org.apache.ode.daohib.bpel.hobj.HXmlData;
import org.apache.ode.utils.SerializableUtils;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunction;
import org.apache.ode.utils.stl.UnaryFunctionEx;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeDaoImpl
extends HibernateDao
implements ScopeDAO {
    private static final String QRY_VARIABLE = "from " + HXmlData.class.getName() + " as x where x.name = ? and x.scope.id = ?";
    private static final String QRY_CSET = "from " + HCorrelationSet.class.getName() + " as c where c.name = ? and c.scope.id = ?";
    private static final String QRY_SCOPE_EPR = "from " + HPartnerLink.class.getName() + " as e where e.modelId = ? and e.scope = ?";
    private HScope _scope;
    private HashMap<String, XmlDataDAO> _variables = new HashMap();

    public ScopeDaoImpl(SessionManager sm, HScope scope) {
        super(sm, scope);
        this.entering("ScopeDaoImpl.ScopeDaoImpl");
        this._scope = scope;
    }

    public CorrelationSetDAO getCorrelationSet(String corrSetName) {
        HCorrelationSet cs;
        this.entering("ScopeDaoImpl.getCorrelationSet");
        Query qry = this.getSession().createQuery(QRY_CSET);
        qry.setString(0, corrSetName);
        qry.setLong(1, this._scope.getId().longValue());
        List res = qry.list();
        if (res.size() == 0) {
            cs = new HCorrelationSet(this._scope, corrSetName);
            this.getSession().save((Object)cs);
        } else {
            cs = (HCorrelationSet)res.get(0);
        }
        return new CorrelationSetDaoImpl(this._sm, cs);
    }

    public ScopeDAO getParentScope() {
        this.entering("ScopeDaoImpl.getParentScope");
        return this._scope.getParentScope() != null ? new ScopeDaoImpl(this._sm, this._scope.getParentScope()) : null;
    }

    public ProcessInstanceDAO getProcessInstance() {
        this.entering("ScopeDaoImpl.getProcessInstance");
        return new ProcessInstanceDaoImpl(this._sm, this._scope.getInstance());
    }

    public void setState(ScopeStateEnum state) {
        this.entering("ScopeDaoImpl.setState");
        this._scope.setState(state.toString());
        this.getSession().update((Object)this._scope);
    }

    public ScopeStateEnum getState() {
        return new ScopeStateEnum(this._scope.getState());
    }

    public String getName() {
        return this._scope.getName();
    }

    public XmlDataDAO getVariable(String varName) {
        this.entering("ScopeDaoImpl.getVariable");
        XmlDataDAO cached = this._variables.get(varName);
        if (cached != null) {
            return this._variables.get(varName);
        }
        HXmlData data = null;
        for (HXmlData e : this._scope.getVariables()) {
            if (!e.getName().equals(varName) || !e.getScope().getId().equals(this._scope.getId())) continue;
            data = e;
        }
        if (data == null) {
            data = new HXmlData();
            data.setName(varName);
            data.setScope(this._scope);
            this._scope.getVariables().add(data);
        }
        XmlDataDaoImpl varDao = new XmlDataDaoImpl(this._sm, data);
        this._variables.put(varName, varDao);
        return varDao;
    }

    public PartnerLinkDAO createPartnerLink(int modelId, String pLinkName, String myRole, String partnerRole) {
        this.entering("ScopeDaoImpl.createPartnerLink");
        HPartnerLink epr = new HPartnerLink();
        epr.setModelId(modelId);
        epr.setLinkName(pLinkName);
        epr.setMyRole(myRole);
        epr.setPartnerRole(partnerRole);
        epr.setScope(this._scope);
        this.getSession().save((Object)epr);
        PartnerLinkDAOImpl eprDao = new PartnerLinkDAOImpl(this._sm, epr);
        return eprDao;
    }

    public PartnerLinkDAO getPartnerLink(int plinkId) {
        this.entering("ScopeDaoImpl.getPartnerLink");
        Query qry = this.getSession().createQuery(QRY_SCOPE_EPR);
        qry.setInteger(0, plinkId);
        qry.setEntity(1, (Object)this._scope);
        HPartnerLink hpl = (HPartnerLink)qry.uniqueResult();
        if (hpl == null) {
            return null;
        }
        return new PartnerLinkDAOImpl(this._sm, hpl);
    }

    public Collection<PartnerLinkDAO> getPartnerLinks() {
        this.entering("ScopeDaoImpl.getPartnerLinks");
        ArrayList<PartnerLinkDAO> plinks = new ArrayList<PartnerLinkDAO>();
        for (HPartnerLink hPartnerLink : this._scope.getPartnerLinks()) {
            plinks.add(new PartnerLinkDAOImpl(this._sm, hPartnerLink));
        }
        return plinks;
    }

    public Long getScopeInstanceId() {
        return this._scope.getId();
    }

    public int getModelId() {
        return this._scope.getScopeModelId();
    }

    public Set<CorrelationSetDAO> getCorrelationSets() {
        this.entering("ScopeDaoImpl.getCorrelationSets");
        HashSet<CorrelationSetDAO> results = new HashSet<CorrelationSetDAO>();
        for (HCorrelationSet hCorrelationSet : this._scope.getCorrelationSets()) {
            results.add(new CorrelationSetDaoImpl(this._sm, hCorrelationSet));
        }
        return results;
    }

    public Collection<ScopeDAO> getChildScopes() {
        this.entering("ScopeDaoImpl.getChildScopes");
        Query q = this.getSession().createQuery("from " + HScope.class.getName() + " as x where x.parentScope=?");
        q.setEntity(0, (Object)this._scope);
        List hscopes = q.list();
        return CollectionsX.transform(new LinkedList(), (Collection)hscopes, (UnaryFunction)new UnaryFunction<HScope, ScopeDAO>(){

            public ScopeDAO apply(HScope x) {
                return new ScopeDaoImpl(ScopeDaoImpl.this._sm, x);
            }
        });
    }

    public Collection<XmlDataDAO> getVariables() {
        this.entering("ScopeDaoImpl.getVariables");
        Query q = this.getSession().createFilter(this._scope.getVariables(), "where this.scope=?");
        q.setEntity(0, (Object)this._scope);
        return CollectionsX.transform(new LinkedList(), (Collection)q.list(), (UnaryFunction)new UnaryFunction<HXmlData, XmlDataDAO>(){

            public XmlDataDAO apply(HXmlData x) {
                return new XmlDataDaoImpl(ScopeDaoImpl.this._sm, x);
            }
        });
    }

    public List<BpelEvent> listEvents() {
        this.entering("ScopeDaoImpl.listEvents");
        Criteria crit = this._sm.getSession().createCriteria(HBpelEvent.class);
        crit.add((Criterion)Restrictions.eq((String)"scopeId", (Object)this._scope.getId()));
        List hevents = crit.list();
        ArrayList<BpelEvent> ret = new ArrayList<BpelEvent>(hevents.size());
        try {
            CollectionsX.transformEx(ret, (Collection)hevents, (UnaryFunctionEx)new UnaryFunctionEx<HBpelEvent, BpelEvent>(){

                public BpelEvent apply(HBpelEvent x) throws Exception {
                    return (BpelEvent)SerializableUtils.toObject((byte[])x.getData(), (ClassLoader)BpelEvent.class.getClassLoader());
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return ret;
    }
}

