/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.Iterator;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.ScopeDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HVariableProperty;
import org.apache.ode.daohib.bpel.hobj.HXmlData;
import org.apache.ode.utils.DOMUtils;
import org.hibernate.Query;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlDataDaoImpl
extends HibernateDao
implements XmlDataDAO {
    private static final String QUERY_PROPERTY = "from " + HVariableProperty.class.getName() + " as p where p.xmlData.id = ? and p.name = ?";
    private HXmlData _data;
    private Node _node;

    public XmlDataDaoImpl(SessionManager sm, HXmlData hobj) {
        super(sm, hobj);
        this.entering("XmlDataDaoImpl.XmlDataDaoImpl");
        this._data = hobj;
    }

    public boolean isNull() {
        this.entering("XmlDataDaoImpl.isNull");
        return this._data.getData() == null || this._data.getData().length == 0;
    }

    public Node get() {
        this.entering("XmlDataDaoImpl.get");
        if (this._node == null) {
            this._node = this.prepare();
        }
        return this._node;
    }

    public void remove() {
    }

    public void set(Node val) {
        this.entering("XmlDataDaoImpl.set");
        this._node = val;
        this._data.setSimpleType(!(val instanceof Element));
        if (this._data.isSimpleType()) {
            this._data.setData(this._node.getNodeValue().getBytes());
        } else {
            this._data.setData(DOMUtils.domToString((Node)this._node).getBytes());
        }
        this.getSession().saveOrUpdate((Object)this._data);
        this.leaving("XmlDataDaoImpl.set");
    }

    public String getProperty(String propertyName) {
        this.entering("XmlDataDaoImpl.getProperty");
        HVariableProperty p = this._getProperty(propertyName);
        return p == null ? null : p.getValue();
    }

    public void setProperty(String pname, String pvalue) {
        this.entering("XmlDataDaoImpl.setProperty");
        HVariableProperty p = this._getProperty(pname);
        if (p == null) {
            p = new HVariableProperty(this._data, pname, pvalue);
            this.getSession().save((Object)p);
        } else {
            p.setValue(pvalue);
            this.getSession().update((Object)p);
        }
    }

    public ScopeDAO getScopeDAO() {
        this.entering("XmlDataDaoImpl.getScopeDAO");
        return new ScopeDaoImpl(this._sm, this._data.getScope());
    }

    private HVariableProperty _getProperty(String propertyName) {
        this.entering("XmlDataDaoImpl._getProperty");
        Query qry = this.getSession().createQuery(QUERY_PROPERTY);
        qry.setLong(0, this._data.getId().longValue());
        qry.setString(1, propertyName);
        Iterator iter = qry.iterate();
        return iter.hasNext() ? (HVariableProperty)iter.next() : null;
    }

    private Node prepare() {
        if (this._data.getData() == null || this._data.getData().length == 0) {
            return null;
        }
        String data = new String(this._data.getData());
        if (this._data.isSimpleType()) {
            Document d = DOMUtils.newDocument();
            Element e = d.createElement("text-node-wrapper");
            Text tnode = d.createTextNode(data);
            d.appendChild(e);
            e.appendChild(tnode);
            return tnode;
        }
        try {
            return DOMUtils.stringToDOM((String)data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this._data.getName();
    }
}

