/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.hawtdispatch.api;

import org.apache.qpid.proton.engine.Endpoint;
import org.apache.qpid.proton.engine.EndpointError;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.hawtdispatch.api.AmqpConnection;
import org.apache.qpid.proton.hawtdispatch.api.Callback;
import org.apache.qpid.proton.hawtdispatch.api.Future;
import org.apache.qpid.proton.hawtdispatch.api.Promise;
import org.apache.qpid.proton.hawtdispatch.impl.AmqpTransport;
import org.apache.qpid.proton.hawtdispatch.impl.Defer;
import org.apache.qpid.proton.hawtdispatch.impl.Support;
import org.apache.qpid.proton.hawtdispatch.impl.Watch;
import org.apache.qpid.proton.hawtdispatch.impl.WatchBase;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;

abstract class AmqpEndpointBase
extends WatchBase {
    AmqpEndpointBase() {
    }

    protected abstract Endpoint getEndpoint();

    protected abstract AmqpEndpointBase getParent();

    protected AmqpConnection getConnection() {
        return this.getParent().getConnection();
    }

    protected AmqpTransport getTransport() {
        return this.getConnection().transport;
    }

    protected DispatchQueue queue() {
        return this.getTransport().queue();
    }

    protected void assertExecuting() {
        this.getTransport().assertExecuting();
    }

    public void waitForRemoteOpen() throws Exception {
        AmqpEndpointBase.assertNotOnDispatchQueue();
        this.getRemoteOpenFuture().await();
    }

    public Future<Void> getRemoteOpenFuture() {
        final Promise<Void> rc = new Promise<Void>();
        this.queue().execute(new Task(){

            public void run() {
                AmqpEndpointBase.this.onRemoteOpen(rc);
            }
        });
        return rc;
    }

    public void onRemoteOpen(final Callback<Void> cb) {
        this.addWatch(new Watch(){

            @Override
            public boolean execute() {
                switch (AmqpEndpointBase.this.getEndpoint().getRemoteState()) {
                    case ACTIVE: {
                        cb.onSuccess(null);
                        return true;
                    }
                    case CLOSED: {
                        cb.onFailure(Support.illegalState("closed"));
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public EndpointError waitForRemoteClose() throws Exception {
        AmqpEndpointBase.assertNotOnDispatchQueue();
        return this.getRemoteCloseFuture().await();
    }

    public Future<EndpointError> getRemoteCloseFuture() {
        final Promise<EndpointError> rc = new Promise<EndpointError>();
        this.queue().execute(new Task(){

            public void run() {
                AmqpEndpointBase.this.onRemoteClose(rc);
            }
        });
        return rc;
    }

    public void onRemoteClose(final Callback<EndpointError> cb) {
        this.addWatch(new Watch(){

            @Override
            public boolean execute() {
                if (AmqpEndpointBase.this.getEndpoint().getRemoteState() == EndpointState.CLOSED) {
                    cb.onSuccess(AmqpEndpointBase.this.getEndpoint().getRemoteError());
                    return true;
                }
                return false;
            }
        });
    }

    public void close() {
        this.getEndpoint().close();
        this.pumpOut();
    }

    public EndpointState getRemoteState() {
        return this.getEndpoint().getRemoteState();
    }

    public EndpointError getRemoteError() {
        return this.getEndpoint().getRemoteError();
    }

    protected static EndpointError toError(Throwable value) {
        return new EndpointError("error", value.toString());
    }

    protected void attach() {
        this.getTransport().context(this.getEndpoint()).setAttachment((Object)new Attachment());
    }

    protected void defer(Defer defer) {
        this.getTransport().defer(defer);
    }

    protected void pumpOut() {
        this.getTransport().pumpOut();
    }

    protected static void assertNotOnDispatchQueue() {
        assert (Dispatch.getCurrentQueue() == null) : "Not allowed to be called when executing on a dispatch queue";
    }

    class Attachment
    extends Task {
        Attachment() {
        }

        AmqpEndpointBase endpoint() {
            return AmqpEndpointBase.this;
        }

        public void run() {
            AmqpEndpointBase.this.fireWatches();
        }
    }
}

