/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.hawtdispatch.api;

import java.util.UUID;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Endpoint;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.hawtdispatch.api.AmqpConnection;
import org.apache.qpid.proton.hawtdispatch.api.AmqpEndpointBase;
import org.apache.qpid.proton.hawtdispatch.api.AmqpReceiver;
import org.apache.qpid.proton.hawtdispatch.api.AmqpSender;
import org.apache.qpid.proton.hawtdispatch.api.QoS;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;

public class AmqpSession
extends AmqpEndpointBase {
    final AmqpConnection parent;
    final SessionImpl session;

    public AmqpSession(AmqpConnection parent, SessionImpl session) {
        this.parent = parent;
        this.session = session;
        this.attach();
    }

    @Override
    protected Endpoint getEndpoint() {
        return this.session;
    }

    @Override
    protected AmqpConnection getParent() {
        return this.parent;
    }

    public AmqpSender createSender(Target target) {
        return this.createSender(target, QoS.AT_LEAST_ONCE);
    }

    public AmqpSender createSender(Target target, QoS qos) {
        return this.createSender(target, qos, UUID.randomUUID().toString());
    }

    public AmqpSender createSender(Target target, QoS qos, String name) {
        this.assertExecuting();
        SenderImpl sender = this.session.sender(name);
        this.attach();
        sender.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
        this.configureQos((Link)sender, qos);
        sender.open();
        this.pumpOut();
        return new AmqpSender(this, sender, qos);
    }

    public AmqpReceiver createReceiver(Source source) {
        return this.createReceiver(source, QoS.AT_LEAST_ONCE);
    }

    public AmqpReceiver createReceiver(Source source, QoS qos) {
        return this.createReceiver(source, qos, 100);
    }

    public AmqpReceiver createReceiver(Source source, QoS qos, int prefetch) {
        return this.createReceiver(source, qos, prefetch, UUID.randomUUID().toString());
    }

    public AmqpReceiver createReceiver(Source source, QoS qos, int prefetch, String name) {
        this.assertExecuting();
        ReceiverImpl receiver = this.session.receiver(name);
        receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        receiver.flow(prefetch);
        this.configureQos((Link)receiver, qos);
        receiver.open();
        this.pumpOut();
        return new AmqpReceiver(this, receiver, qos);
    }

    private void configureQos(Link link, QoS qos) {
        switch (qos) {
            case AT_MOST_ONCE: {
                link.setSenderSettleMode(SenderSettleMode.SETTLED);
                link.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                break;
            }
            case AT_LEAST_ONCE: {
                link.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                link.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                break;
            }
            case EXACTLY_ONCE: {
                link.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                link.setReceiverSettleMode(ReceiverSettleMode.SECOND);
            }
        }
    }

    public Message createTextMessage(String value) {
        MessageImpl msg = new MessageImpl();
        AmqpValue body = new AmqpValue((Object)value);
        msg.setBody((Section)body);
        return msg;
    }

    public Message createBinaryMessage(byte[] value) {
        return this.createBinaryMessage(value, 0, value.length);
    }

    public Message createBinaryMessage(byte[] value, int offset, int len) {
        MessageImpl msg = new MessageImpl();
        Data body = new Data(new Binary(value, offset, len));
        msg.setBody((Section)body);
        return msg;
    }
}

