/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.hawtdispatch.api;

import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.hawtdispatch.api.AmqpEndpointBase;
import org.apache.qpid.proton.hawtdispatch.api.AmqpLink;
import org.apache.qpid.proton.hawtdispatch.api.Callback;
import org.apache.qpid.proton.hawtdispatch.api.Future;
import org.apache.qpid.proton.hawtdispatch.api.Promise;
import org.apache.qpid.proton.hawtdispatch.impl.Watch;
import org.apache.qpid.proton.hawtdispatch.impl.WatchBase;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdispatch.Task;

public abstract class MessageDelivery
extends WatchBase {
    final int initialSize;
    private Message message;
    private Buffer encoded;
    public DeliveryImpl delivery;
    private int sizeHint = 32;
    boolean watchingRemoteStateChange;

    static Buffer encode(Message message, int sizeHint) {
        byte[] buffer = new byte[sizeHint];
        int size = ((MessageImpl)message).encode2(buffer, 0, sizeHint);
        if (size > sizeHint) {
            buffer = new byte[size];
            size = message.encode(buffer, 0, size);
        }
        return new Buffer(buffer, 0, size);
    }

    static Message decode(Buffer buffer) {
        int decoded;
        MessageImpl msg = new MessageImpl();
        int offset = buffer.offset;
        for (int len = buffer.length; len > 0; len -= decoded) {
            decoded = msg.decode(buffer.data, offset, len);
            assert (decoded > 0) : "Make progress decoding the message";
            offset += decoded;
        }
        return msg;
    }

    public MessageDelivery(Message message) {
        this(message, MessageDelivery.encode(message, 32));
    }

    public MessageDelivery(Buffer encoded) {
        this(null, encoded);
    }

    public MessageDelivery(Message message, Buffer encoded) {
        this.message = message;
        this.encoded = encoded;
        this.initialSize = this.sizeHint = this.encoded.length;
    }

    public Message getMessage() {
        if (this.message == null) {
            this.message = MessageDelivery.decode(this.encoded);
        }
        return this.message;
    }

    public Buffer encoded() {
        if (this.encoded == null) {
            this.encoded = MessageDelivery.encode(this.message, this.sizeHint);
            this.sizeHint = this.encoded.length;
        }
        return this.encoded;
    }

    public boolean isSettled() {
        return this.delivery != null && this.delivery.isSettled();
    }

    public DeliveryState getRemoteState() {
        return this.delivery == null ? null : this.delivery.getRemoteState();
    }

    public DeliveryState getLocalState() {
        return this.delivery == null ? null : this.delivery.getLocalState();
    }

    public void onEncoded(final Callback<Void> cb) {
        this.addWatch(new Watch(){

            @Override
            public boolean execute() {
                if (MessageDelivery.this.delivery != null) {
                    cb.onSuccess(null);
                    return true;
                }
                return false;
            }
        });
    }

    public DeliveryState getRemoteStateChange() throws Exception {
        AmqpEndpointBase.assertNotOnDispatchQueue();
        return this.getRemoteStateChangeFuture().await();
    }

    public Future<DeliveryState> getRemoteStateChangeFuture() {
        final Promise<DeliveryState> rc = new Promise<DeliveryState>();
        this.link().queue().execute(new Task(){

            public void run() {
                MessageDelivery.this.onRemoteStateChange(rc);
            }
        });
        return rc;
    }

    abstract AmqpLink link();

    public void onRemoteStateChange(final Callback<DeliveryState> cb) {
        this.watchingRemoteStateChange = true;
        final DeliveryState original = this.delivery.getRemoteState();
        this.addWatch(new Watch(){

            @Override
            public boolean execute() {
                if (original == null) {
                    if (MessageDelivery.this.delivery.getRemoteState() != null) {
                        cb.onSuccess(MessageDelivery.this.delivery.getRemoteState());
                        MessageDelivery.this.watchingRemoteStateChange = false;
                        return true;
                    }
                } else if (!original.equals(MessageDelivery.this.delivery.getRemoteState())) {
                    cb.onSuccess(MessageDelivery.this.delivery.getRemoteState());
                    MessageDelivery.this.watchingRemoteStateChange = false;
                    return true;
                }
                return false;
            }
        });
    }

    public DeliveryState getSettle() throws Exception {
        AmqpEndpointBase.assertNotOnDispatchQueue();
        return this.getSettleFuture().await();
    }

    public Future<DeliveryState> getSettleFuture() {
        final Promise<DeliveryState> rc = new Promise<DeliveryState>();
        this.link().queue().execute(new Task(){

            public void run() {
                MessageDelivery.this.onSettle(rc);
            }
        });
        return rc;
    }

    public void onSettle(final Callback<DeliveryState> cb) {
        this.addWatch(new Watch(){

            @Override
            public boolean execute() {
                if (MessageDelivery.this.delivery != null && MessageDelivery.this.delivery.isSettled()) {
                    cb.onSuccess(MessageDelivery.this.delivery.getRemoteState());
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    protected void fireWatches() {
        super.fireWatches();
    }

    void incrementDeliveryCount() {
        Message msg = this.getMessage();
        msg.setDeliveryCount(msg.getDeliveryCount() + 1L);
        this.encoded = null;
    }

    public void redeliver(boolean incrementDeliveryCounter) {
        if (incrementDeliveryCounter) {
            this.incrementDeliveryCount();
        }
    }

    public void settle() {
        if (!this.delivery.isSettled()) {
            this.delivery.settle();
        }
    }
}

