/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.hawtdispatch.impl;

import org.apache.qpid.proton.engine.Endpoint;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.hawtdispatch.impl.AmqpListener;
import org.apache.qpid.proton.hawtdispatch.impl.AmqpTransport;
import org.fusesource.hawtdispatch.Task;

public class EndpointContext {
    private final AmqpTransport transport;
    private final Endpoint endpoint;
    private Object attachment;
    boolean listenerProcessing;

    public EndpointContext(AmqpTransport transport, Endpoint endpoint) {
        this.transport = transport;
        this.endpoint = endpoint;
    }

    public void fireListenerEvents(AmqpListener listener) {
        if (listener != null && !this.listenerProcessing) {
            if (this.endpoint.getLocalState() == EndpointState.UNINITIALIZED && this.endpoint.getRemoteState() != EndpointState.UNINITIALIZED) {
                this.listenerProcessing = true;
                listener.processRemoteOpen(this.endpoint, new ProcessedTask());
            } else if (this.endpoint.getLocalState() == EndpointState.ACTIVE && this.endpoint.getRemoteState() == EndpointState.CLOSED) {
                this.listenerProcessing = true;
                listener.processRemoteClose(this.endpoint, new ProcessedTask());
            }
        }
        if (this.attachment != null && this.attachment instanceof Task) {
            ((Task)this.attachment).run();
        }
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public <T> T getAttachment(Class<T> clazz) {
        return clazz.cast(this.getAttachment());
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    class ProcessedTask
    extends Task {
        ProcessedTask() {
        }

        public void run() {
            EndpointContext.this.transport.assertExecuting();
            EndpointContext.this.listenerProcessing = false;
            EndpointContext.this.transport.pumpOut();
        }
    }
}

