/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.hawtdispatch.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.fusesource.hawtdispatch.DispatchQueue;

public class AmqpConnectOptions
implements Cloneable {
    private static final long KEEP_ALIVE = Long.parseLong(System.getProperty("amqp.thread.keep_alive", "1000"));
    private static final long STACK_SIZE = Long.parseLong(System.getProperty("amqp.thread.stack_size", "524288"));
    private static ThreadPoolExecutor blockingThreadPool;
    private static final URI DEFAULT_HOST;
    URI host = DEFAULT_HOST;
    URI localAddress;
    SSLContext sslContext;
    DispatchQueue dispatchQueue;
    Executor blockingExecutor;
    int maxReadRate;
    int maxWriteRate;
    int trafficClass = 8;
    boolean useLocalHost;
    int receiveBufferSize = 65536;
    int sendBufferSize = 65536;
    String localContainerId;
    String remoteContainerId;
    String user;
    String password;

    public static synchronized ThreadPoolExecutor getBlockingThreadPool() {
        if (blockingThreadPool == null) {
            blockingThreadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, KEEP_ALIVE, TimeUnit.MILLISECONDS, (BlockingQueue)new SynchronousQueue(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread rc = new Thread(null, r, "AMQP Task", STACK_SIZE);
                    rc.setDaemon(true);
                    return rc;
                }
            }){

                @Override
                public void shutdown() {
                }

                @Override
                public List<Runnable> shutdownNow() {
                    return Collections.emptyList();
                }
            };
        }
        return blockingThreadPool;
    }

    public static synchronized void setBlockingThreadPool(ThreadPoolExecutor pool) {
        blockingThreadPool = pool;
    }

    public AmqpConnectOptions clone() {
        try {
            return (AmqpConnectOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLocalContainerId() {
        return this.localContainerId;
    }

    public void setLocalContainerId(String localContainerId) {
        this.localContainerId = localContainerId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRemoteContainerId() {
        return this.remoteContainerId;
    }

    public void setRemoteContainerId(String remoteContainerId) {
        this.remoteContainerId = remoteContainerId;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Executor getBlockingExecutor() {
        return this.blockingExecutor;
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }

    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void setDispatchQueue(DispatchQueue dispatchQueue) {
        this.dispatchQueue = dispatchQueue;
    }

    public URI getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) throws URISyntaxException {
        this.setLocalAddress(new URI(localAddress));
    }

    public void setLocalAddress(URI localAddress) {
        this.localAddress = localAddress;
    }

    public int getMaxReadRate() {
        return this.maxReadRate;
    }

    public void setMaxReadRate(int maxReadRate) {
        this.maxReadRate = maxReadRate;
    }

    public int getMaxWriteRate() {
        return this.maxWriteRate;
    }

    public void setMaxWriteRate(int maxWriteRate) {
        this.maxWriteRate = maxWriteRate;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public URI getHost() {
        return this.host;
    }

    public void setHost(String host, int port) throws URISyntaxException {
        this.setHost(new URI("tcp://" + host + ":" + port));
    }

    public void setHost(String host) throws URISyntaxException {
        this.setHost(new URI(host));
    }

    public void setHost(URI host) {
        this.host = host;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public boolean isUseLocalHost() {
        return this.useLocalHost;
    }

    public void setUseLocalHost(boolean useLocalHost) {
        this.useLocalHost = useLocalHost;
    }

    static {
        try {
            DEFAULT_HOST = new URI("tcp://localhost");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

