/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.hawtdispatch.impl;

import java.io.IOException;
import org.apache.qpid.proton.hawtdispatch.impl.AmqpHeader;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdispatch.transport.AbstractProtocolCodec;

public class AmqpProtocolCodec
extends AbstractProtocolCodec {
    int maxFrameSize = 0x400000;
    private final AbstractProtocolCodec.Action readFrameSize = new AbstractProtocolCodec.Action(){

        public Object apply() throws IOException {
            Buffer sizeBytes = AmqpProtocolCodec.this.peekBytes(4);
            if (sizeBytes != null) {
                int size = sizeBytes.bigEndianEditor().readInt();
                if (size < 8) {
                    throw new IOException(String.format("specified frame size %d is smaller than minimum frame size", size));
                }
                if (size > AmqpProtocolCodec.this.maxFrameSize) {
                    throw new IOException(String.format("specified frame size %d is larger than maximum frame size", size));
                }
                AmqpProtocolCodec.this.nextDecodeAction = AmqpProtocolCodec.this.readFrame(size);
                return AmqpProtocolCodec.this.nextDecodeAction.apply();
            }
            return null;
        }
    };

    protected void encode(Object object) throws IOException {
        this.nextWriteBuffer.write((Buffer)object);
    }

    protected AbstractProtocolCodec.Action initialDecodeAction() {
        return new AbstractProtocolCodec.Action(){

            public Object apply() throws IOException {
                Buffer magic = AmqpProtocolCodec.this.readBytes(8);
                if (magic != null) {
                    AmqpProtocolCodec.this.nextDecodeAction = AmqpProtocolCodec.this.readFrameSize;
                    return new AmqpHeader(magic);
                }
                return null;
            }
        };
    }

    private final AbstractProtocolCodec.Action readFrame(final int size) {
        return new AbstractProtocolCodec.Action(){

            public Object apply() throws IOException {
                Buffer frameData = AmqpProtocolCodec.this.readBytes(size);
                if (frameData != null) {
                    AmqpProtocolCodec.this.nextDecodeAction = AmqpProtocolCodec.this.readFrameSize;
                    return frameData;
                }
                return null;
            }
        };
    }

    public int getReadBytesPendingDecode() {
        return this.readBuffer.position() - this.readStart;
    }

    public void skipProtocolHeader() {
        this.nextDecodeAction = this.readFrameSize;
    }

    public void readProtocolHeader() {
        this.nextDecodeAction = this.initialDecodeAction();
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }
}

