/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.example;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.messenger.impl.MessengerImpl;

public class Recv {
    private static Logger tracer = Logger.getLogger("proton.example");
    private boolean verbose = false;
    private int maxct = 0;
    private List<String> addrs = new ArrayList<String>();

    private static void usage() {
        System.err.println("Usage: recv [-v] [-n MAXCT] [-a ADDRESS]*");
        System.exit(2);
    }

    private Recv(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).startsWith("-")) {
                if ("-v".equals(arg)) {
                    this.verbose = true;
                    continue;
                }
                if ("-a".equals(arg)) {
                    this.addrs.add(args[i++]);
                    continue;
                }
                if ("-n".equals(arg)) {
                    this.maxct = Integer.valueOf(args[i++]);
                    continue;
                }
                System.err.println("unknown option " + arg);
                Recv.usage();
                continue;
            }
            Recv.usage();
        }
        if (this.addrs.size() == 0) {
            this.addrs.add("amqp://~0.0.0.0");
        }
    }

    private static String safe(Object o) {
        return String.valueOf(o);
    }

    private void print(int i, Message msg) {
        StringBuilder b = new StringBuilder("message: ");
        b.append(i).append("\n");
        b.append("Address: ").append(msg.getAddress()).append("\n");
        b.append("Subject: ").append(msg.getSubject()).append("\n");
        if (this.verbose) {
            b.append("Props:     ").append(msg.getProperties()).append("\n");
            b.append("App Props: ").append(msg.getApplicationProperties()).append("\n");
            b.append("Msg Anno:  ").append(msg.getMessageAnnotations()).append("\n");
            b.append("Del Anno:  ").append(msg.getDeliveryAnnotations()).append("\n");
        } else {
            ApplicationProperties p = msg.getApplicationProperties();
            String s = p == null ? "null" : Recv.safe(p.getValue());
            b.append("Headers: ").append(s).append("\n");
        }
        b.append(msg.getBody()).append("\n");
        b.append("END").append("\n");
        System.out.println(b.toString());
    }

    private void run() {
        try {
            MessengerImpl mng = new MessengerImpl();
            mng.start();
            for (String a : this.addrs) {
                mng.subscribe(a);
            }
            int ct = 0;
            boolean done = false;
            block3: while (!done) {
                mng.recv();
                while (mng.incoming() > 0) {
                    Message msg = mng.get();
                    this.print(++ct, msg);
                    if (this.maxct <= 0 || ct < this.maxct) continue;
                    done = true;
                    continue block3;
                }
            }
            mng.stop();
        }
        catch (Exception e) {
            tracer.log(Level.SEVERE, "proton error", e);
        }
    }

    public static void main(String[] args) {
        Recv o = new Recv(args);
        o.run();
    }
}

