/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.example;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.apache.qpid.proton.messenger.impl.MessengerImpl;

public class Send {
    private static Logger tracer = Logger.getLogger("proton.example");
    private String address = "amqp://0.0.0.0/test";
    private String subject;
    private String[] bodies;

    private static void usage() {
        System.err.println("Usage: send [-a ADDRESS] [-s SUBJECT] MSG+");
        System.exit(2);
    }

    private Send(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).startsWith("-")) {
                if ("-a".equals(arg)) {
                    this.address = args[i++];
                    continue;
                }
                if ("-s".equals(arg)) {
                    this.subject = args[i++];
                    continue;
                }
                System.err.println("unknown option " + arg);
                Send.usage();
                continue;
            }
            --i;
            break;
        }
        this.bodies = Arrays.copyOfRange(args, i, args.length);
    }

    private void run() {
        try {
            MessengerImpl mng = new MessengerImpl();
            mng.start();
            MessageImpl msg = new MessageImpl();
            msg.setAddress(this.address);
            if (this.subject != null) {
                msg.setSubject(this.subject);
            }
            for (String body : this.bodies) {
                msg.setBody((Section)new AmqpValue((Object)body));
                mng.put((Message)msg);
            }
            mng.send();
            mng.stop();
        }
        catch (Exception e) {
            tracer.log(Level.SEVERE, "proton error", e);
        }
    }

    public static void main(String[] args) {
        Send o = new Send(args);
        o.run();
    }
}

