/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingCalendar;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class QpidCompositeRollingAppender
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    static final int BY_SIZE = 1;
    static final int BY_DATE = 2;
    static final int BY_COMPOSITE = 3;
    static final String S_BY_SIZE = "Size";
    static final String S_BY_DATE = "Date";
    static final String S_BY_COMPOSITE = "Composite";
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename = null;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingCalendar rc = new RollingCalendar();
    int checkPeriod = -1;
    protected long maxFileSize = 0xA00000L;
    protected int maxSizeRollBackups = 0;
    protected int curSizeRollBackups = 0;
    protected int maxTimeRollBackups = -1;
    protected int curTimeRollBackups = 0;
    protected int countDirection = -1;
    protected int rollingStyle = 3;
    protected boolean rollDate = true;
    protected boolean rollSize = true;
    protected boolean staticLogFileName = true;
    protected String baseFileName;
    protected boolean compress = false;
    protected boolean compressAsync = false;
    protected boolean zeroBased = false;
    protected String backupFilesToPath = null;
    private final ConcurrentLinkedQueue<CompressJob> _compress = new ConcurrentLinkedQueue();
    private AtomicBoolean _compressing = new AtomicBoolean(false);
    Compressor compressor = null;
    Executor executor;

    public QpidCompositeRollingAppender() {
    }

    public QpidCompositeRollingAppender(Layout layout, String filename, String datePattern) throws IOException {
        this(layout, filename, datePattern, true);
    }

    public QpidCompositeRollingAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public QpidCompositeRollingAppender(Layout layout, String filename, String datePattern, boolean append) throws IOException {
        super(layout, filename, append);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public QpidCompositeRollingAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public int getMaxSizeRollBackups() {
        return this.maxSizeRollBackups;
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void setMaxSizeRollBackups(int maxBackups) {
        this.maxSizeRollBackups = maxBackups;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaximumFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    int computeCheckPeriod() {
        RollingCalendar c = new RollingCalendar();
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                String r0 = this.sdf.format(epoch);
                c.setType(i);
                Date next = new Date(c.getNextCheckMillis(epoch));
                String r1 = this.sdf.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    protected void subAppend(LoggingEvent event) {
        long n;
        if (this.rollDate && (n = System.currentTimeMillis()) >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            this.rollOverTime();
        }
        if (this.rollSize && this.fileName != null && ((CountingQuietWriter)this.qw).getCount() >= this.maxFileSize) {
            this.rollOverSize();
        }
        super.subAppend(event);
    }

    public void setFile(String file) {
        this.baseFileName = file.trim();
        this.fileName = file.trim();
    }

    public synchronized void setFile(String fileName, boolean append) throws IOException {
        if (!this.staticLogFileName) {
            this.scheduledFilename = fileName = fileName.trim() + this.sdf.format(this.now);
            if (this.countDirection > 0) {
                this.scheduledFilename = fileName = fileName + '.' + ++this.curSizeRollBackups;
            }
        }
        super.setFile(fileName, append, this.bufferedIO, this.bufferSize);
        if (append) {
            File f = new File(fileName);
            ((CountingQuietWriter)this.qw).setCount(f.length());
        }
    }

    public int getCountDirection() {
        return this.countDirection;
    }

    public void setCountDirection(int direction) {
        this.countDirection = direction;
    }

    public int getRollingStyle() {
        return this.rollingStyle;
    }

    public void setRollingStyle(int style) {
        this.rollingStyle = style;
        switch (this.rollingStyle) {
            case 1: {
                this.rollDate = false;
                this.rollSize = true;
                break;
            }
            case 2: {
                this.rollDate = true;
                this.rollSize = false;
                break;
            }
            case 3: {
                this.rollDate = true;
                this.rollSize = true;
                break;
            }
            default: {
                this.errorHandler.error("Invalid rolling Style, use 1 (by size only), 2 (by date only) or 3 (both)");
            }
        }
    }

    public boolean getStaticLogFileName() {
        return this.staticLogFileName;
    }

    public void setStaticLogFileName(boolean s) {
        this.staticLogFileName = s;
    }

    public void setStaticLogFileName(String value) {
        this.setStaticLogFileName(OptionConverter.toBoolean((String)value, (boolean)true));
    }

    public boolean getCompressBackupFiles() {
        return this.compress;
    }

    public void setCompressBackupFiles(boolean c) {
        this.compress = c;
    }

    public boolean getCompressAsync() {
        return this.compressAsync;
    }

    public void setCompressAsync(boolean c) {
        this.compressAsync = c;
        if (this.compressAsync) {
            this.executor = Executors.newFixedThreadPool(1);
            this.compressor = new Compressor();
        }
    }

    public boolean getZeroBased() {
        return this.zeroBased;
    }

    public void setZeroBased(boolean z) {
        this.zeroBased = z;
    }

    public String getBackupFilesToPath() {
        return this.backupFilesToPath;
    }

    public void setbackupFilesToPath(String path) {
        File td = new File(path);
        if (!td.exists()) {
            td.mkdirs();
        }
        this.backupFilesToPath = path;
    }

    protected void existingInit() {
        Date last;
        File old;
        if (this.zeroBased) {
            this.curSizeRollBackups = -1;
        }
        this.curTimeRollBackups = 0;
        String filter = this.staticLogFileName || !this.rollDate ? this.baseFileName + ".*" : this.scheduledFilename + ".*";
        File f = new File(this.baseFileName);
        if ((f = f.getParentFile()) == null) {
            f = new File(".");
        }
        LogLog.debug((String)("Searching for existing files in: " + f));
        String[] files = f.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].startsWith(this.baseFileName)) continue;
                int index = files[i].lastIndexOf(".");
                if (this.staticLogFileName) {
                    int endLength = files[i].length() - index;
                    if (this.baseFileName.length() + endLength != files[i].length()) continue;
                }
                try {
                    int backup = Integer.parseInt(files[i].substring(index + 1, files[i].length()));
                    LogLog.debug((String)("From file: " + files[i] + " -> " + backup));
                    if (backup <= this.curSizeRollBackups) continue;
                    this.curSizeRollBackups = backup;
                    continue;
                }
                catch (Exception e) {
                    LogLog.debug((String)("Encountered a backup file not ending in .x " + files[i]));
                }
            }
        }
        LogLog.debug((String)("curSizeRollBackups starts at: " + this.curSizeRollBackups));
        if (this.staticLogFileName && this.rollDate && (old = new File(this.baseFileName)).exists() && !this.sdf.format(last = new Date(old.lastModified())).equals(this.sdf.format(this.now))) {
            this.scheduledFilename = this.baseFileName + this.sdf.format(last);
            LogLog.debug((String)("Initial roll over to: " + this.scheduledFilename));
            this.rollOverTime();
        }
        LogLog.debug((String)("curSizeRollBackups after rollOver at: " + this.curSizeRollBackups));
    }

    public void activateOptions() {
        if (this.datePattern != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.rc.setType(type);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
        } else if (this.rollDate) {
            LogLog.error((String)("Either DatePattern or rollingStyle options are not set for [" + this.name + "]."));
        }
        this.existingInit();
        if (this.rollDate && this.fileName != null && this.scheduledFilename == null) {
            this.scheduledFilename = this.fileName + this.sdf.format(this.now);
        }
        try {
            this.setFile(this.fileName, true);
        }
        catch (IOException e) {
            this.errorHandler.error("Cannot set file name:" + this.fileName);
        }
        super.activateOptions();
    }

    protected void rollOverTime() {
        ++this.curTimeRollBackups;
        this.closeFile();
        if (this.staticLogFileName) {
            if (this.datePattern == null) {
                this.errorHandler.error("Missing DatePattern option in rollOver().");
                return;
            }
            String dateFormat = this.sdf.format(this.now);
            if (this.scheduledFilename.equals(this.fileName + dateFormat)) {
                this.errorHandler.error("Compare " + this.scheduledFilename + " : " + this.fileName + dateFormat);
                return;
            }
            this.closeFile();
            for (int i = 1; i <= this.curSizeRollBackups; ++i) {
                String from = this.fileName + '.' + i;
                String to = this.scheduledFilename + '.' + i;
                this.rollFile(from, to, false);
            }
            this.rollFile(this.fileName, this.scheduledFilename, this.compress);
        } else if (this.compress) {
            this.compress(this.fileName);
        }
        try {
            this.curSizeRollBackups = 0;
            this.scheduledFilename = this.fileName + this.sdf.format(this.now);
            this.setFile(this.baseFileName, false);
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
    }

    protected void rollFile(String from, String to, boolean compress) {
        if (from.equals(to)) {
            if (compress) {
                LogLog.debug((String)"Attempting to compress file with same output name.");
            }
            return;
        }
        File target = new File(to);
        if (target.exists()) {
            LogLog.debug((String)("deleting existing target file: " + target));
            target.delete();
        }
        File file = new File(from);
        if (compress) {
            this.compress(file, target);
        } else if (!file.getPath().equals(target.getPath())) {
            file.renameTo(target);
        }
        LogLog.debug((String)(from + " -> " + to));
    }

    protected void compress(String file) {
        File f = new File(file);
        this.compress(f, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(File from, File target) {
        if (this.compressAsync) {
            ConcurrentLinkedQueue<CompressJob> concurrentLinkedQueue = this._compress;
            synchronized (concurrentLinkedQueue) {
                this._compress.offer(new CompressJob(from, target));
            }
            this.startCompression();
        } else {
            this.doCompress(from, target);
        }
    }

    private void startCompression() {
        if (this._compressing.compareAndSet(false, true)) {
            this.executor.execute(this.compressor);
        }
    }

    protected static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    protected void rollOverSize() {
        this.closeFile();
        LogLog.debug((String)("rolling over count=" + ((CountingQuietWriter)this.qw).getCount()));
        LogLog.debug((String)("maxSizeRollBackups = " + this.maxSizeRollBackups));
        LogLog.debug((String)("curSizeRollBackups = " + this.curSizeRollBackups));
        LogLog.debug((String)("countDirection = " + this.countDirection));
        if (this.maxSizeRollBackups != 0) {
            if (this.countDirection < 0) {
                if (this.curSizeRollBackups == this.maxSizeRollBackups) {
                    QpidCompositeRollingAppender.deleteFile(this.fileName + '.' + this.maxSizeRollBackups);
                    --this.curSizeRollBackups;
                }
                for (int i = this.curSizeRollBackups; i >= 1; --i) {
                    this.rollFile(this.fileName + "." + i, this.fileName + '.' + (i + 1), false);
                }
                ++this.curSizeRollBackups;
                this.rollFile(this.fileName, this.fileName + ".1", this.compress);
            } else if (this.countDirection == 0) {
                ++this.curSizeRollBackups;
                this.now.setTime(System.currentTimeMillis());
                this.scheduledFilename = this.fileName + this.sdf.format(this.now);
                this.rollFile(this.fileName, this.scheduledFilename, this.compress);
            } else {
                if (this.curSizeRollBackups >= this.maxSizeRollBackups && this.maxSizeRollBackups > 0) {
                    int oldestFileIndex = this.curSizeRollBackups - this.maxSizeRollBackups + 1;
                    QpidCompositeRollingAppender.deleteFile(this.fileName + '.' + oldestFileIndex);
                }
                if (this.staticLogFileName) {
                    ++this.curSizeRollBackups;
                    this.rollFile(this.fileName, this.fileName + '.' + this.curSizeRollBackups, this.compress);
                } else if (this.compress) {
                    this.compress(this.fileName);
                }
            }
        }
        try {
            this.setFile(this.baseFileName, false);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }

    protected synchronized void doCompress(File from, File to) {
        String toFile = this.backupFilesToPath == null ? to.getPath() + ".gz" : this.backupFilesToPath + System.getProperty("file.separator") + to.getName() + ".gz";
        File target = new File(toFile);
        if (target.exists()) {
            LogLog.debug((String)("deleting existing target file: " + target));
            target.delete();
        }
        try {
            int len;
            GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(target));
            FileInputStream in = new FileInputStream(from);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.finish();
            out.close();
            from.delete();
        }
        catch (IOException e) {
            if (target.exists()) {
                target.delete();
            }
            this.rollFile(from.getPath(), to.getPath(), false);
        }
    }

    private class Compressor
    implements Runnable {
        private Compressor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean running = true;
            while (running) {
                CompressJob job = (CompressJob)QpidCompositeRollingAppender.this._compress.poll();
                QpidCompositeRollingAppender.this.doCompress(job.getFrom(), job.getTo());
                ConcurrentLinkedQueue concurrentLinkedQueue = QpidCompositeRollingAppender.this._compress;
                synchronized (concurrentLinkedQueue) {
                    if (QpidCompositeRollingAppender.this._compress.isEmpty()) {
                        running = false;
                        QpidCompositeRollingAppender.this._compressing.set(false);
                    }
                }
            }
        }
    }

    private class CompressJob {
        File _from;
        File _to;

        CompressJob(File from, File to) {
            this._from = from;
            this._to = to;
        }

        File getFrom() {
            return this._from;
        }

        File getTo() {
            return this._to;
        }
    }
}

