/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.management.AMQManagedObject;
import org.apache.qpid.server.management.MBeanConstructor;
import org.apache.qpid.server.management.MBeanDescription;
import org.apache.qpid.server.management.ManagedBroker;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.virtualhost.VirtualHost;

@MBeanDescription(value="This MBean exposes the broker level management features")
public class AMQBrokerManagerMBean
extends AMQManagedObject
implements ManagedBroker {
    private final QueueRegistry _queueRegistry;
    private final ExchangeRegistry _exchangeRegistry;
    private final ExchangeFactory _exchangeFactory;
    private final MessageStore _messageStore;
    private final VirtualHost.VirtualHostMBean _virtualHostMBean;

    @MBeanConstructor(value="Creates the Broker Manager MBean")
    public AMQBrokerManagerMBean(VirtualHost.VirtualHostMBean virtualHostMBean) throws JMException {
        super(ManagedBroker.class, "VirtualHostManager", 1);
        this._virtualHostMBean = virtualHostMBean;
        VirtualHost virtualHost = virtualHostMBean.getVirtualHost();
        this._queueRegistry = virtualHost.getQueueRegistry();
        this._exchangeRegistry = virtualHost.getExchangeRegistry();
        this._messageStore = virtualHost.getMessageStore();
        this._exchangeFactory = virtualHost.getExchangeFactory();
    }

    public String getObjectInstanceName() {
        return this._virtualHostMBean.getVirtualHost().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewExchange(String exchangeName, String type, boolean durable) throws JMException {
        try {
            ExchangeRegistry exchangeRegistry = this._exchangeRegistry;
            synchronized (exchangeRegistry) {
                Exchange exchange = this._exchangeRegistry.getExchange(new AMQShortString(exchangeName));
                if (exchange != null) {
                    throw new JMException("The exchange \"" + exchangeName + "\" already exists.");
                }
                exchange = this._exchangeFactory.createExchange(new AMQShortString(exchangeName), new AMQShortString(type), durable, false, 0);
                this._exchangeRegistry.registerExchange(exchange);
            }
        }
        catch (AMQException ex) {
            throw new MBeanException((Exception)((Object)ex), "Error in creating exchange " + exchangeName);
        }
    }

    public void unregisterExchange(String exchangeName) throws JMException {
        try {
            this._exchangeRegistry.unregisterExchange(new AMQShortString(exchangeName), false);
        }
        catch (AMQException ex) {
            throw new MBeanException((Exception)((Object)ex), "Error in unregistering exchange " + exchangeName);
        }
    }

    public void createNewQueue(String queueName, String owner, boolean durable) throws JMException {
        AMQQueue queue = this._queueRegistry.getQueue(new AMQShortString(queueName));
        if (queue != null) {
            throw new JMException("The queue \"" + queueName + "\" already exists.");
        }
        try {
            AMQShortString ownerShortString = null;
            if (owner != null) {
                ownerShortString = new AMQShortString(owner);
            }
            if ((queue = AMQQueueFactory.createAMQQueueImpl(new AMQShortString(queueName), durable, ownerShortString, false, this.getVirtualHost(), null)).isDurable() && !queue.isAutoDelete()) {
                this._messageStore.createQueue(queue);
            }
            this._queueRegistry.registerQueue(queue);
        }
        catch (AMQException ex) {
            JMException jme = new JMException(ex.getMessage());
            jme.initCause(ex);
            throw new MBeanException(jme, "Error in creating queue " + queueName);
        }
    }

    private VirtualHost getVirtualHost() {
        return this._virtualHostMBean.getVirtualHost();
    }

    public void deleteQueue(String queueName) throws JMException {
        AMQQueue queue = this._queueRegistry.getQueue(new AMQShortString(queueName));
        if (queue == null) {
            throw new JMException("The Queue " + queueName + " is not a registerd queue.");
        }
        try {
            queue.delete();
            this._messageStore.removeQueue(queue);
        }
        catch (AMQException ex) {
            JMException jme = new JMException(ex.getMessage());
            jme.initCause(ex);
            throw new MBeanException(jme, "Error in deleting queue " + queueName);
        }
    }

    public ManagedObject getParentObject() {
        return this._virtualHostMBean;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return this.getObjectNameForSingleInstanceMBean();
    }
}

