/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.ack.UnacknowledgedMessageMap;
import org.apache.qpid.server.queue.AMQMessage;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.StoreContext;
import org.apache.qpid.server.subscription.Subscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractResendAndRequeue
implements UnacknowledgedMessageMap.Visitor {
    private static final Logger _log = Logger.getLogger(ExtractResendAndRequeue.class);
    private Map<Long, QueueEntry> _msgToRequeue;
    private Map<Long, QueueEntry> _msgToResend;
    private boolean _requeueIfUnabletoResend;
    private StoreContext _storeContext;
    private UnacknowledgedMessageMap _unacknowledgedMessageMap;

    public ExtractResendAndRequeue(UnacknowledgedMessageMap unacknowledgedMessageMap, Map<Long, QueueEntry> msgToRequeue, Map<Long, QueueEntry> msgToResend, boolean requeueIfUnabletoResend, StoreContext storeContext) {
        this._unacknowledgedMessageMap = unacknowledgedMessageMap;
        this._msgToRequeue = msgToRequeue;
        this._msgToResend = msgToResend;
        this._requeueIfUnabletoResend = requeueIfUnabletoResend;
        this._storeContext = storeContext;
    }

    @Override
    public boolean callback(long deliveryTag, QueueEntry message) throws AMQException {
        AMQMessage msg = message.getMessage();
        msg.setRedelivered(true);
        Subscription subscription = message.getDeliveredSubscription();
        if (subscription != null) {
            if (!subscription.isClosed()) {
                this._msgToResend.put(deliveryTag, message);
            } else {
                this._msgToRequeue.put(deliveryTag, message);
            }
        } else if (!message.isQueueDeleted()) {
            if (this._requeueIfUnabletoResend) {
                this._msgToRequeue.put(deliveryTag, message);
            } else {
                message.discard(this._storeContext);
                _log.info((Object)("No DeadLetter Queue and requeue not requested so dropping message:" + message));
            }
        } else {
            message.discard(this._storeContext);
            _log.warn((Object)("Message.queue is null and no DeadLetter Queue so dropping message:" + message));
        }
        return false;
    }

    @Override
    public void visitComplete() {
        this._unacknowledgedMessageMap.clear();
    }
}

