/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.FixedSizeByteBufferAllocator;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.transport.socket.nio.MultiThreadSocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.mina.util.NewThreadExecutor;
import org.apache.qpid.AMQException;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.pool.ReadWriteThreadModel;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.configuration.management.ConfigurationManagementMBean;
import org.apache.qpid.server.logging.management.LoggingManagementMBean;
import org.apache.qpid.server.protocol.AMQPFastProtocolHandler;
import org.apache.qpid.server.protocol.AMQPProtocolProvider;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.ConfigurationFileApplicationRegistry;

public class Main {
    private static final Logger _logger = Logger.getLogger(Main.class);
    public static final Logger _brokerLogger = Logger.getLogger((String)"Qpid.Broker");
    private static final String DEFAULT_CONFIG_FILE = "etc/config.xml";
    private static final String DEFAULT_LOG_CONFIG_FILENAME = "log4j.xml";
    public static final String QPID_HOME = "QPID_HOME";
    private static final int IPV4_ADDRESS_LENGTH = 4;
    private static final char IPV4_LITERAL_SEPARATOR = '.';
    protected final Options options = new Options();
    protected CommandLine commandLine;

    protected Main(String[] args) {
        this.setOptions(this.options);
        if (this.parseCommandline(args)) {
            this.execute();
        }
    }

    protected boolean parseCommandline(String[] args) {
        try {
            this.commandLine = new PosixParser().parse(this.options, args);
            return true;
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Qpid", this.options, true);
            return false;
        }
    }

    protected void setOptions(Options options) {
        Option help = new Option("h", "help", false, "print this message");
        Option version = new Option("v", "version", false, "print the version information and exit");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given configuration file");
        OptionBuilder.withLongOpt((String)"config");
        Option configFile = OptionBuilder.create((String)"c");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"listen on the specified port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"port");
        Option port = OptionBuilder.create((String)"p");
        OptionBuilder.withArgName((String)"mport");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"listen on the specified management port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"mport");
        Option mport = OptionBuilder.create((String)"m");
        OptionBuilder.withArgName((String)"bind");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"bind to the specified address. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"bind");
        Option bind = OptionBuilder.create((String)"b");
        OptionBuilder.withArgName((String)"logconfig");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use the specified log4j xml configuration file. By default looks for a file named log4j.xml in the same directory as the configuration file");
        OptionBuilder.withLongOpt((String)"logconfig");
        Option logconfig = OptionBuilder.create((String)"l");
        OptionBuilder.withArgName((String)"logwatch");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"monitor the log file configuration file for changes. Units are seconds. Zero means do not check for changes.");
        OptionBuilder.withLongOpt((String)"logwatch");
        Option logwatchconfig = OptionBuilder.create((String)"w");
        options.addOption(help);
        options.addOption(version);
        options.addOption(configFile);
        options.addOption(logconfig);
        options.addOption(logwatchconfig);
        options.addOption(port);
        options.addOption(mport);
        options.addOption(bind);
    }

    protected void execute() {
        if (this.commandLine.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Qpid", this.options, true);
        } else if (this.commandLine.hasOption("v")) {
            String ver = QpidProperties.getVersionString();
            StringBuilder protocol = new StringBuilder("AMQP version(s) [major.minor]: ");
            boolean first = true;
            for (ProtocolVersion pv : ProtocolVersion.getSupportedProtocolVersions()) {
                if (first) {
                    first = false;
                } else {
                    protocol.append(", ");
                }
                protocol.append(pv.getMajorVersion()).append('-').append(pv.getMinorVersion());
            }
            System.out.println(ver + " (" + protocol + ")");
        } else {
            try {
                this.startup();
            }
            catch (InitException e) {
                System.out.println(e.getMessage());
                _brokerLogger.error((Object)("Initialisation Error : " + e.getMessage()));
                this.shutdown(1);
            }
            catch (Throwable e) {
                System.out.println("Error initialising message broker: " + e);
                _brokerLogger.error((Object)("Error initialising message broker: " + e));
                e.printStackTrace();
                this.shutdown(1);
            }
        }
    }

    protected void shutdown(int status) {
        ApplicationRegistry.removeAll();
        System.exit(status);
    }

    protected void startup() throws Exception {
        File logConfigFile;
        String QpidHome = System.getProperty(QPID_HOME);
        File defaultConfigFile = new File(QpidHome, DEFAULT_CONFIG_FILE);
        File configFile = new File(this.commandLine.getOptionValue("c", defaultConfigFile.getPath()));
        if (!configFile.exists()) {
            String error = "File " + configFile + " could not be found. Check the file exists and is readable.";
            if (QpidHome == null) {
                error = error + "\nNote: " + QPID_HOME + " is not set.";
            }
            throw new InitException(error, null);
        }
        System.out.println("Using configuration file " + configFile.getAbsolutePath());
        String logConfig = this.commandLine.getOptionValue("l");
        String logWatchConfig = this.commandLine.getOptionValue("w", "0");
        int logWatchTime = 0;
        try {
            logWatchTime = Integer.parseInt(logWatchConfig);
        }
        catch (NumberFormatException e) {
            System.err.println("Log watch configuration value of " + logWatchConfig + " is invalid. Must be " + "a non-negative integer. Using default of zero (no watching configured");
        }
        if (logConfig != null) {
            logConfigFile = new File(logConfig);
            this.configureLogging(logConfigFile, logWatchTime);
        } else {
            File configFileDirectory = configFile.getParentFile();
            logConfigFile = new File(configFileDirectory, DEFAULT_LOG_CONFIG_FILENAME);
            this.configureLogging(logConfigFile, logWatchTime);
        }
        ConfigurationFileApplicationRegistry config = new ConfigurationFileApplicationRegistry(configFile);
        ServerConfiguration serverConfig = config.getConfiguration();
        this.updateManagementPort(serverConfig, this.commandLine.getOptionValue("m"));
        ApplicationRegistry.initialise(config);
        this.configureLoggingManagementMBean(logConfigFile, logWatchTime);
        ConfigurationManagementMBean configMBean = new ConfigurationManagementMBean();
        configMBean.register();
        _brokerLogger.info((Object)("Starting Qpid Broker " + QpidProperties.getReleaseVersion() + " build: " + QpidProperties.getBuildVersion()));
        ByteBuffer.setUseDirectBuffers((boolean)serverConfig.getEnableDirectBuffers());
        if (!serverConfig.getEnablePooledAllocator()) {
            ByteBuffer.setAllocator((ByteBufferAllocator)new FixedSizeByteBufferAllocator());
        }
        if (serverConfig.getUseBiasedWrites()) {
            System.setProperty("org.apache.qpid.use_write_biased_pool", "true");
        }
        int port = serverConfig.getPort();
        String portStr = this.commandLine.getOptionValue("p");
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                throw new InitException("Invalid port: " + portStr, e);
            }
        }
        this.bind(port, serverConfig);
    }

    private void updateManagementPort(ServerConfiguration configuration, String managementPort) {
        if (managementPort != null) {
            try {
                configuration.setJMXManagementPort(Integer.parseInt(managementPort));
            }
            catch (NumberFormatException e) {
                _logger.warn((Object)("Invalid management port: " + managementPort + " will use:" + configuration.getJMXManagementPort()), (Throwable)e);
            }
        }
    }

    protected void bind(int port, ServerConfiguration config) throws BindException {
        String bindAddr = this.commandLine.getOptionValue("b");
        if (bindAddr == null) {
            bindAddr = config.getBind();
        }
        try {
            AMQPFastProtocolHandler handler;
            MultiThreadSocketAcceptor acceptor;
            if (ApplicationRegistry.getInstance().getConfiguration().getQpidNIO()) {
                _logger.warn((Object)"Using Qpid Multithreaded IO Processing");
                acceptor = new MultiThreadSocketAcceptor(config.getProcessors(), (Executor)new NewThreadExecutor());
            } else {
                _logger.warn((Object)"Using Mina IO Processing");
                acceptor = new SocketAcceptor(config.getProcessors(), (Executor)new NewThreadExecutor());
            }
            SocketAcceptorConfig sconfig = (SocketAcceptorConfig)acceptor.getDefaultConfig();
            SocketSessionConfig sc = (SocketSessionConfig)sconfig.getSessionConfig();
            sc.setReceiveBufferSize(config.getReceiveBufferSize());
            sc.setSendBufferSize(config.getWriteBufferSize());
            sc.setTcpNoDelay(config.getTcpNoDelay());
            if (config.getEnableExecutorPool()) {
                sconfig.setThreadModel((ThreadModel)ReadWriteThreadModel.getInstance());
            }
            if (!config.getEnableSSL() || !config.getSSLOnly()) {
                handler = new AMQPProtocolProvider().getHandler();
                InetSocketAddress bindAddress = bindAddr.equals("wildcard") ? new InetSocketAddress(port) : new InetSocketAddress(InetAddress.getByAddress(this.parseIP(bindAddr)), port);
                this.bind((IoAcceptor)acceptor, bindAddress, handler, sconfig);
                _brokerLogger.info((Object)("Qpid.AMQP listening on non-SSL address " + bindAddress));
            }
            if (config.getEnableSSL()) {
                handler = new AMQPProtocolProvider().getHandler();
                try {
                    this.bind((IoAcceptor)acceptor, new InetSocketAddress(config.getSSLPort()), handler, sconfig);
                    _brokerLogger.info((Object)("Qpid.AMQP listening on SSL port " + config.getSSLPort()));
                }
                catch (IOException e) {
                    _brokerLogger.error((Object)("Unable to listen on SSL port: " + e), (Throwable)e);
                }
            }
            _brokerLogger.info((Object)("Qpid Broker Ready :" + QpidProperties.getReleaseVersion() + " build: " + QpidProperties.getBuildVersion()));
        }
        catch (Exception e) {
            _logger.error((Object)("Unable to bind service to registry: " + e), (Throwable)e);
            throw new BindException(e.getMessage());
        }
    }

    private void bind(IoAcceptor acceptor, InetSocketAddress bindAddress, AMQPFastProtocolHandler handler, SocketAcceptorConfig sconfig) throws IOException {
        acceptor.bind((SocketAddress)bindAddress, (IoHandler)handler, (IoServiceConfig)sconfig);
        ApplicationRegistry.getInstance().addAcceptor(bindAddress, acceptor);
    }

    public static void main(String[] args) {
        new Main(args);
    }

    private byte[] parseIP(String address) throws Exception {
        char[] literalBuffer = address.toCharArray();
        int byteCount = 0;
        int currByte = 0;
        byte[] ip = new byte[4];
        for (int i = 0; i < literalBuffer.length; ++i) {
            char currChar = literalBuffer[i];
            if (currChar >= '0' && currChar <= '9') {
                currByte = currByte * 10 + (Character.digit(currChar, 10) & 0xFF);
            }
            if (currChar != '.' && i + 1 != literalBuffer.length) continue;
            ip[byteCount++] = (byte)currByte;
            currByte = 0;
        }
        if (byteCount != 4) {
            throw new Exception("Invalid IP address: " + address);
        }
        return ip;
    }

    private void configureLogging(File logConfigFile, int logWatchTime) {
        if (logConfigFile.exists() && logConfigFile.canRead()) {
            System.out.println("Configuring logger using configuration file " + logConfigFile.getAbsolutePath());
            if (logWatchTime > 0) {
                System.out.println("log file " + logConfigFile.getAbsolutePath() + " will be checked for changes every " + logWatchTime + " seconds");
                DOMConfigurator.configureAndWatch((String)logConfigFile.getAbsolutePath(), (long)(logWatchTime * 1000));
            } else {
                DOMConfigurator.configure((String)logConfigFile.getAbsolutePath());
            }
        } else {
            System.err.println("Logging configuration error: unable to read file " + logConfigFile.getAbsolutePath());
            System.err.println("Using basic log4j configuration");
            BasicConfigurator.configure();
        }
    }

    private void configureLoggingManagementMBean(File logConfigFile, int logWatchTime) throws Exception {
        LoggingManagementMBean blm = new LoggingManagementMBean(logConfigFile.getPath(), logWatchTime);
        try {
            blm.register();
        }
        catch (AMQException e) {
            throw new InitException("Unable to initialise the Logging Management MBean: ", e);
        }
    }

    protected static class InitException
    extends Exception {
        InitException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

