/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.ack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.ack.UnacknowledgedMessageMap;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.StoreContext;
import org.apache.qpid.server.txn.TxnOp;

public class TxAck
implements TxnOp {
    private final UnacknowledgedMessageMap _map;
    private final Map<Long, QueueEntry> _unacked = new HashMap<Long, QueueEntry>();
    private List<Long> _individual;
    private long _deliveryTag;
    private boolean _multiple;

    public TxAck(UnacknowledgedMessageMap map) {
        this._map = map;
    }

    public void update(long deliveryTag, boolean multiple) {
        this._unacked.clear();
        if (!multiple) {
            if (this._individual == null) {
                this._individual = new ArrayList<Long>();
            }
            this._individual.add(deliveryTag);
        } else if (deliveryTag > this._deliveryTag) {
            this._deliveryTag = deliveryTag;
            this._multiple = true;
        }
    }

    public void consolidate() {
        if (this._unacked.isEmpty()) {
            if (this._multiple) {
                this._map.collect(this._deliveryTag, true, this._unacked);
            }
            if (this._individual != null) {
                for (long tag : this._individual) {
                    if (this._deliveryTag >= tag) continue;
                    this._map.collect(tag, false, this._unacked);
                }
            }
        }
    }

    public boolean checkPersistent() throws AMQException {
        this.consolidate();
        for (QueueEntry msg : this._unacked.values()) {
            if (!msg.getMessage().isPersistent()) continue;
            return true;
        }
        return false;
    }

    public void prepare(StoreContext storeContext) throws AMQException {
        for (QueueEntry msg : this._unacked.values()) {
            msg.discard(storeContext);
        }
    }

    public void undoPrepare() {
        for (QueueEntry msg : this._unacked.values()) {
            msg.getMessage().takeReference();
        }
    }

    public void commit(StoreContext storeContext) {
        this._map.remove(this._unacked);
    }

    public void rollback(StoreContext storeContext) {
    }
}

