/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.ack;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.ack.UnacknowledgedMessageMap;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.StoreContext;
import org.apache.qpid.server.txn.TransactionalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnacknowledgedMessageMapImpl
implements UnacknowledgedMessageMap {
    private final Object _lock = new Object();
    private long _unackedSize;
    private Map<Long, QueueEntry> _map;
    private long _lastDeliveryTag;
    private final int _prefetchLimit;

    public UnacknowledgedMessageMapImpl(int prefetchLimit) {
        this._prefetchLimit = prefetchLimit;
        this._map = new LinkedHashMap<Long, QueueEntry>(prefetchLimit);
    }

    @Override
    public void collect(long deliveryTag, boolean multiple, Map<Long, QueueEntry> msgs) {
        if (multiple) {
            this.collect(deliveryTag, msgs);
        } else {
            msgs.put(deliveryTag, this.get(deliveryTag));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(long deliveryTag) throws AMQException {
        Object object = this._lock;
        synchronized (object) {
            return this._map.containsKey(deliveryTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Map<Long, QueueEntry> msgs) {
        Object object = this._lock;
        synchronized (object) {
            for (Long deliveryTag : msgs.keySet()) {
                this.remove(deliveryTag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueEntry remove(long deliveryTag) {
        Object object = this._lock;
        synchronized (object) {
            QueueEntry message = this._map.remove(deliveryTag);
            if (message != null) {
                this._unackedSize -= message.getMessage().getSize();
            }
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(UnacknowledgedMessageMap.Visitor visitor) throws AMQException {
        Object object = this._lock;
        synchronized (object) {
            Set<Map.Entry<Long, QueueEntry>> currentEntries = this._map.entrySet();
            for (Map.Entry<Long, QueueEntry> entry : currentEntries) {
                visitor.callback(entry.getKey(), entry.getValue());
            }
            visitor.visitComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(long deliveryTag, QueueEntry message) {
        Object object = this._lock;
        synchronized (object) {
            this._map.put(deliveryTag, message);
            this._unackedSize += message.getMessage().getSize();
            this._lastDeliveryTag = deliveryTag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<QueueEntry> cancelAllMessages() {
        Object object = this._lock;
        synchronized (object) {
            Collection<QueueEntry> currentEntries = this._map.values();
            this._map = new LinkedHashMap<Long, QueueEntry>(this._prefetchLimit);
            this._unackedSize = 0L;
            return currentEntries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledgeMessage(long deliveryTag, boolean multiple, TransactionalContext txnContext) throws AMQException {
        Object object = this._lock;
        synchronized (object) {
            txnContext.acknowledgeMessage(deliveryTag, this._lastDeliveryTag, multiple, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this._lock;
        synchronized (object) {
            return this._map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._map.clear();
            this._unackedSize = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drainTo(long deliveryTag, StoreContext storeContext) throws AMQException {
        Object object = this._lock;
        synchronized (object) {
            Iterator<Map.Entry<Long, QueueEntry>> it = this._map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, QueueEntry> unacked = it.next();
                if (unacked.getKey() > deliveryTag) {
                    throw new AMQException("UnacknowledgedMessageMap is out of order:" + unacked.getKey() + " When deliveryTag is:" + deliveryTag + "ES:" + this._map.entrySet().toString());
                }
                unacked.getValue().discard(storeContext);
                it.remove();
                this._unackedSize -= unacked.getValue().getMessage().getSize();
                if (unacked.getKey() != deliveryTag) continue;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueEntry get(long key) {
        Object object = this._lock;
        synchronized (object) {
            return this._map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getDeliveryTags() {
        Object object = this._lock;
        synchronized (object) {
            return this._map.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collect(long key, Map<Long, QueueEntry> msgs) {
        Object object = this._lock;
        synchronized (object) {
            for (Map.Entry<Long, QueueEntry> entry : this._map.entrySet()) {
                msgs.put(entry.getKey(), entry.getValue());
                if (entry.getKey() != key) continue;
                break;
            }
        }
    }

    @Override
    public long getUnacknowledgeBytes() {
        return this._unackedSize;
    }
}

