/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;

public class QueueConfiguration {
    private Configuration _config;
    private String _name;
    private VirtualHostConfiguration _vHostConfig;

    public QueueConfiguration(String name, Configuration config, VirtualHostConfiguration virtualHostConfiguration) {
        this._vHostConfig = virtualHostConfiguration;
        this._config = config;
        this._name = name;
    }

    public VirtualHostConfiguration getVirtualHostConfiguration() {
        return this._vHostConfig;
    }

    public boolean getDurable() {
        return this._config.getBoolean("durable", false);
    }

    public boolean getAutoDelete() {
        return this._config.getBoolean("autodelete", false);
    }

    public String getOwner() {
        return this._config.getString("owner", null);
    }

    public boolean getPriority() {
        return this._config.getBoolean("priority", false);
    }

    public int getPriorities() {
        return this._config.getInt("priorities", -1);
    }

    public String getExchange() {
        return this._config.getString("exchange", null);
    }

    public List getRoutingKeys() {
        return this._config.getList("routingKey");
    }

    public String getName() {
        return this._name;
    }

    public int getMaximumMessageAge() {
        return this._config.getInt("maximumMessageAge", this._vHostConfig.getMaximumMessageAge());
    }

    public long getMaximumQueueDepth() {
        return this._config.getLong("maximumQueueDepth", this._vHostConfig.getMaximumQueueDepth());
    }

    public long getMaximumMessageSize() {
        return this._config.getLong("maximumMessageSize", this._vHostConfig.getMaximumMessageSize());
    }

    public long getMaximumMessageCount() {
        return this._config.getLong("maximumMessageCount", this._vHostConfig.getMaximumMessageCount());
    }

    public long getMinimumAlertRepeatGap() {
        return this._config.getLong("minimumAlertRepeatGap", this._vHostConfig.getMinimumAlertRepeatGap());
    }
}

