/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.qpid.server.configuration.SecurityConfiguration;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.configuration.management.ConfigurationManagementMBean;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConfiguration
implements SignalHandler {
    private Configuration _config;
    private static final int DEFAULT_FRAME_SIZE = 65536;
    private static final int DEFAULT_BUFFER_READ_LIMIT_SIZE = 262144;
    private static final int DEFAULT_BUFFER_WRITE_LIMIT_SIZE = 262144;
    private static final int DEFAULT_PORT = 5672;
    private static final int DEFAUL_SSL_PORT = 8672;
    private static final long DEFAULT_HOUSEKEEPING_PERIOD = 30000L;
    private static final int DEFAULT_JMXPORT = 8999;
    private static int _jmxPort = 8999;
    private Map<String, VirtualHostConfiguration> _virtualHosts = new HashMap<String, VirtualHostConfiguration>();
    private SecurityConfiguration _securityConfiguration = null;
    private File _configFile;
    private Logger _log = LoggerFactory.getLogger(this.getClass());
    private ConfigurationManagementMBean _mbean;
    private static final Map<String, String> envVarMap = new HashMap<String, String>();

    public ServerConfiguration(File configurationURL) throws ConfigurationException {
        this(ServerConfiguration.parseConfig(configurationURL));
        this._configFile = configurationURL;
        try {
            Signal sig = new Signal("HUP");
            Signal.handle(sig, this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public ServerConfiguration(Configuration conf) throws ConfigurationException {
        envVarMap.put("QPID_PORT", "connector.port");
        envVarMap.put("QPID_ENABLEDIRECTBUFFERS", "advanced.enableDirectBuffers");
        envVarMap.put("QPID_SSLPORT", "connector.ssl.port");
        envVarMap.put("QPID_NIO", "connector.qpidnio");
        envVarMap.put("QPID_WRITEBIASED", "advanced.useWriteBiasedPool");
        envVarMap.put("QPID_JMXPORT", "management.jmxport");
        envVarMap.put("QPID_FRAMESIZE", "advanced.framesize");
        envVarMap.put("QPID_MSGAUTH", "security.msg-auth");
        envVarMap.put("QPID_AUTOREGISTER", "auto_register");
        envVarMap.put("QPID_MANAGEMENTENABLED", "management.enabled");
        envVarMap.put("QPID_HEARTBEATDELAY", "heartbeat.delay");
        envVarMap.put("QPID_HEARTBEATTIMEOUTFACTOR", "heartbeat.timeoutFactor");
        envVarMap.put("QPID_MAXIMUMMESSAGEAGE", "maximumMessageAge");
        envVarMap.put("QPID_MAXIMUMMESSAGECOUNT", "maximumMessageCount");
        envVarMap.put("QPID_MAXIMUMQUEUEDEPTH", "maximumQueueDepth");
        envVarMap.put("QPID_MAXIMUMMESSAGESIZE", "maximumMessageSize");
        envVarMap.put("QPID_MINIMUMALERTREPEATGAP", "minimumAlertRepeatGap");
        envVarMap.put("QPID_SOCKETRECEIVEBUFFER", "connector.socketReceiveBuffer");
        envVarMap.put("QPID_SOCKETWRITEBUFFER", "connector.socketWriteBuffer");
        envVarMap.put("QPID_TCPNODELAY", "connector.tcpNoDelay");
        envVarMap.put("QPID_ENABLEPOOLEDALLOCATOR", "advanced.enablePooledAllocator");
        this.setConfig(conf);
        this.substituteEnvironmentVariables();
        _jmxPort = this.getConfig().getInt("management.jmxport", 8999);
        this._securityConfiguration = new SecurityConfiguration(conf.subset("security"));
        this.setupVirtualHosts(conf);
    }

    private void setupVirtualHosts(Configuration conf) throws ConfigurationException {
        List vhosts = conf.getList("virtualhosts");
        for (Object thing : vhosts) {
            if (!(thing instanceof String)) continue;
            XMLConfiguration vhostConfiguration = new XMLConfiguration((String)thing);
            List hosts = vhostConfiguration.getList("virtualhost.name");
            for (int j = 0; j < hosts.size(); ++j) {
                String name = (String)hosts.get(j);
                Configuration myConf = vhostConfiguration.subset("virtualhost." + name);
                Iterator k = myConf.getKeys();
                while (k.hasNext()) {
                    String key = (String)k.next();
                    conf.setProperty("virtualhosts.virtualhost." + name + "." + key, myConf.getProperty(key));
                }
                VirtualHostConfiguration vhostConfig = new VirtualHostConfiguration(name, conf.subset("virtualhosts.virtualhost." + name));
                this._virtualHosts.put(vhostConfig.getName(), vhostConfig);
            }
            Iterator keys = vhostConfiguration.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                conf.setProperty("virtualhosts." + key, vhostConfiguration.getProperty(key));
            }
        }
    }

    private void substituteEnvironmentVariables() {
        for (Map.Entry<String, String> var : envVarMap.entrySet()) {
            String val = System.getenv(var.getKey());
            if (val == null) continue;
            this.getConfig().setProperty(var.getValue(), (Object)val);
        }
    }

    private static final Configuration parseConfig(File file) throws ConfigurationException {
        ConfigurationFactory factory = new ConfigurationFactory();
        factory.setConfigurationFileName(file.getAbsolutePath());
        Configuration conf = factory.getConfiguration();
        Iterator keys = conf.getKeys();
        if (!keys.hasNext()) {
            keys = null;
            conf = ServerConfiguration.flatConfig(file);
        }
        return conf;
    }

    private static final Configuration flatConfig(File file) throws ConfigurationException {
        final MyConfiguration conf = new MyConfiguration();
        conf.addConfiguration((Configuration)new SystemConfiguration(){

            protected String interpolate(String o) {
                return conf.interpolate(o);
            }
        });
        conf.addConfiguration((Configuration)new XMLConfiguration(file){

            protected String interpolate(String o) {
                return conf.interpolate(o);
            }
        });
        return conf;
    }

    @Override
    public void handle(Signal arg0) {
        try {
            this.reparseConfigFile();
        }
        catch (ConfigurationException e) {
            this._log.error("Could not reload configuration file", (Throwable)e);
        }
    }

    public void reparseConfigFile() throws ConfigurationException {
        if (this._configFile != null) {
            Configuration newConfig = ServerConfiguration.parseConfig(this._configFile);
            this._securityConfiguration = new SecurityConfiguration(newConfig.subset("security"));
            ApplicationRegistry.getInstance().getAccessManager().configurePlugins(this._securityConfiguration);
            VirtualHostRegistry vhostRegistry = ApplicationRegistry.getInstance().getVirtualHostRegistry();
            for (String hostname : this._virtualHosts.keySet()) {
                VirtualHost vhost = vhostRegistry.getVirtualHost(hostname);
                SecurityConfiguration hostSecurityConfig = new SecurityConfiguration(newConfig.subset("virtualhosts.virtualhost." + hostname + ".security"));
                vhost.getAccessManager().configureHostPlugins(hostSecurityConfig);
            }
        }
    }

    public void setConfig(Configuration _config) {
        this._config = _config;
    }

    public Configuration getConfig() {
        return this._config;
    }

    public String getQpidWork() {
        return System.getProperty("QPID_WORK", System.getProperty("java.io.tmpdir"));
    }

    public void setJMXManagementPort(int mport) {
        _jmxPort = mport;
    }

    public int getJMXManagementPort() {
        return _jmxPort;
    }

    public boolean getPlatformMbeanserver() {
        return this.getConfig().getBoolean("management.platform-mbeanserver", true);
    }

    public String[] getVirtualHosts() {
        return this._virtualHosts.keySet().toArray(new String[this._virtualHosts.size()]);
    }

    public String getPluginDirectory() {
        return this.getConfig().getString("plugin-directory");
    }

    public VirtualHostConfiguration getVirtualHostConfig(String name) {
        return this._virtualHosts.get(name);
    }

    public List<String> getPrincipalDatabaseNames() {
        return this.getConfig().getList("security.principal-databases.principal-database.name");
    }

    public List<String> getPrincipalDatabaseClass() {
        return this.getConfig().getList("security.principal-databases.principal-database.class");
    }

    public List<String> getPrincipalDatabaseAttributeNames(int index) {
        String name = "security.principal-databases.principal-database(" + index + ")." + "attributes.attribute.name";
        return this.getConfig().getList(name);
    }

    public List<String> getPrincipalDatabaseAttributeValues(int index) {
        String name = "security.principal-databases.principal-database(" + index + ")." + "attributes.attribute.value";
        return this.getConfig().getList(name);
    }

    public List<String> getManagementPrincipalDBs() {
        return this.getConfig().getList("security.jmx.principal-database");
    }

    public List<String> getManagementAccessList() {
        return this.getConfig().getList("security.jmx.access");
    }

    public int getFrameSize() {
        return this.getConfig().getInt("advanced.framesize", 65536);
    }

    public boolean getProtectIOEnabled() {
        return this.getConfig().getBoolean("broker.connector.protectio.enabled", false);
    }

    public int getBufferReadLimit() {
        return this.getConfig().getInt("broker.connector.protectio.readBufferLimitSize", 262144);
    }

    public int getBufferWriteLimit() {
        return this.getConfig().getInt("broker.connector.protectio.writeBufferLimitSize", 262144);
    }

    public boolean getSynchedClocks() {
        return this.getConfig().getBoolean("advanced.synced-clocks", false);
    }

    public boolean getMsgAuth() {
        return this.getConfig().getBoolean("security.msg-auth", false);
    }

    public String getJMXPrincipalDatabase() {
        return this.getConfig().getString("security.jmx.principal-database");
    }

    public String getManagementKeyStorePath() {
        return this.getConfig().getString("management.ssl.keyStorePath", null);
    }

    public boolean getManagementSSLEnabled() {
        return this.getConfig().getBoolean("management.ssl.enabled", true);
    }

    public String getManagementKeyStorePassword() {
        return this.getConfig().getString("management.ssl.keyStorePassword");
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this._securityConfiguration;
    }

    public boolean getQueueAutoRegister() {
        return this.getConfig().getBoolean("queue.auto_register", true);
    }

    public boolean getManagementEnabled() {
        return this.getConfig().getBoolean("management.enabled", true);
    }

    public void setManagementEnabled(boolean enabled) {
        this.getConfig().setProperty("management.enabled", (Object)enabled);
    }

    public int getHeartBeatDelay() {
        return this.getConfig().getInt("heartbeat.delay", 5);
    }

    public double getHeartBeatTimeout() {
        return this.getConfig().getDouble("heartbeat.timeoutFactor", 2.0);
    }

    public int getDeliveryPoolSize() {
        return this.getConfig().getInt("delivery.poolsize", 0);
    }

    public long getMaximumMessageAge() {
        return this.getConfig().getLong("maximumMessageAge", 0L);
    }

    public long getMaximumMessageCount() {
        return this.getConfig().getLong("maximumMessageCount", 0L);
    }

    public long getMaximumQueueDepth() {
        return this.getConfig().getLong("maximumQueueDepth", 0L);
    }

    public long getMaximumMessageSize() {
        return this.getConfig().getLong("maximumMessageSize", 0L);
    }

    public long getMinimumAlertRepeatGap() {
        return this.getConfig().getLong("minimumAlertRepeatGap", 0L);
    }

    public int getProcessors() {
        return this.getConfig().getInt("connector.processors", 4);
    }

    public int getPort() {
        return this.getConfig().getInt("connector.port", 5672);
    }

    public String getBind() {
        return this.getConfig().getString("connector.bind", "wildcard");
    }

    public int getReceiveBufferSize() {
        return this.getConfig().getInt("connector.socketReceiveBuffer", Short.MAX_VALUE);
    }

    public int getWriteBufferSize() {
        return this.getConfig().getInt("connector.socketWriteBuffer", Short.MAX_VALUE);
    }

    public boolean getTcpNoDelay() {
        return this.getConfig().getBoolean("connector.tcpNoDelay", true);
    }

    public boolean getEnableExecutorPool() {
        return this.getConfig().getBoolean("advanced.filterchain[@enableExecutorPool]", false);
    }

    public boolean getEnablePooledAllocator() {
        return this.getConfig().getBoolean("advanced.enablePooledAllocator", false);
    }

    public boolean getEnableDirectBuffers() {
        return this.getConfig().getBoolean("advanced.enableDirectBuffers", false);
    }

    public boolean getEnableSSL() {
        return this.getConfig().getBoolean("connector.ssl.enabled", false);
    }

    public boolean getSSLOnly() {
        return this.getConfig().getBoolean("connector.ssl.sslOnly", true);
    }

    public int getSSLPort() {
        return this.getConfig().getInt("connector.ssl.port", 8672);
    }

    public String getKeystorePath() {
        return this.getConfig().getString("connector.ssl.keystorePath", "none");
    }

    public String getKeystorePassword() {
        return this.getConfig().getString("connector.ssl.keystorePassword", "none");
    }

    public String getCertType() {
        return this.getConfig().getString("connector.ssl.certType", "SunX509");
    }

    public boolean getQpidNIO() {
        return this.getConfig().getBoolean("connector.qpidnio", false);
    }

    public boolean getUseBiasedWrites() {
        return this.getConfig().getBoolean("advanced.useWriteBiasedPool", false);
    }

    public String getDefaultVirtualHost() {
        return this.getConfig().getString("virtualhosts.default");
    }

    public void setHousekeepingExpiredMessageCheckPeriod(long value) {
        this.getConfig().setProperty("housekeeping.expiredMessageCheckPeriod", (Object)value);
    }

    public long getHousekeepingCheckPeriod() {
        return this.getConfig().getLong("housekeeping.checkPeriod", this.getConfig().getLong("housekeeping.expiredMessageCheckPeriod", 30000L));
    }

    private static class MyConfiguration
    extends CompositeConfiguration {
        private MyConfiguration() {
        }

        public String interpolate(String obj) {
            return super.interpolate(obj);
        }
    }
}

