/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.qpid.server.configuration.ExchangeConfiguration;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.configuration.SecurityConfiguration;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.store.MemoryMessageStore;

public class VirtualHostConfiguration {
    private Configuration _config;
    private String _name;
    private Map<String, QueueConfiguration> _queues = new HashMap<String, QueueConfiguration>();
    private Map<String, ExchangeConfiguration> _exchanges = new HashMap<String, ExchangeConfiguration>();

    public VirtualHostConfiguration(String name, Configuration config) throws ConfigurationException {
        CompositeConfiguration mungedConf;
        this._config = config;
        this._name = name;
        for (String queueName : this._config.getList("queues.queue.name")) {
            mungedConf = new CompositeConfiguration();
            mungedConf.addConfiguration(this._config.subset("queues.queue." + queueName));
            mungedConf.addConfiguration(this._config.subset("queues"));
            this._queues.put(queueName, new QueueConfiguration(queueName, (Configuration)mungedConf, this));
        }
        Iterator i = this._config.getList("exchanges.exchange.name").iterator();
        int count = 0;
        while (i.hasNext()) {
            mungedConf = new CompositeConfiguration();
            mungedConf.addConfiguration(config.subset("exchanges.exchange(" + count++ + ")"));
            mungedConf.addConfiguration(this._config.subset("exchanges"));
            String exchName = (String)i.next();
            this._exchanges.put(exchName, new ExchangeConfiguration(exchName, (Configuration)mungedConf));
        }
    }

    public String getName() {
        return this._name;
    }

    public long getHousekeepingExpiredMessageCheckPeriod() {
        return this._config.getLong("housekeeping.expiredMessageCheckPeriod", ApplicationRegistry.getInstance().getConfiguration().getHousekeepingCheckPeriod());
    }

    public String getAuthenticationDatabase() {
        return this._config.getString("security.authentication.name");
    }

    public List getCustomExchanges() {
        return this._config.getList("custom-exchanges.class-name");
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return new SecurityConfiguration(this._config.subset("security"));
    }

    public Configuration getStoreConfiguration() {
        return this._config.subset("store");
    }

    public String getMessageStoreClass() {
        return this._config.getString("store.class", MemoryMessageStore.class.getName());
    }

    public List getExchanges() {
        return this._config.getList("exchanges.exchange.name");
    }

    public String[] getQueueNames() {
        return this._queues.keySet().toArray(new String[this._queues.size()]);
    }

    public ExchangeConfiguration getExchangeConfiguration(String exchangeName) {
        return this._exchanges.get(exchangeName);
    }

    public QueueConfiguration getQueueConfiguration(String queueName) {
        if (this._queues.containsKey(queueName)) {
            return this._queues.get(queueName);
        }
        return new QueueConfiguration(queueName, (Configuration)new PropertiesConfiguration(), this);
    }

    public long getMemoryUsageMaximum() {
        return this._config.getLong("queues.maximumMemoryUsage", 0L);
    }

    public long getMemoryUsageMinimum() {
        return this._config.getLong("queues.minimumMemoryUsage", 0L);
    }

    public int getMaximumMessageAge() {
        return this._config.getInt("queues.maximumMessageAge", 0);
    }

    public Long getMaximumQueueDepth() {
        return this._config.getLong("queues.maximumQueueDepth", 0L);
    }

    public Long getMaximumMessageSize() {
        return this._config.getLong("queues.maximumMessageSize", 0L);
    }

    public Long getMaximumMessageCount() {
        return this._config.getLong("queues.maximumMessageCount", 0L);
    }

    public Long getMinimumAlertRepeatGap() {
        return this._config.getLong("queues.minimumAlertRepeatGap", 0L);
    }
}

