/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.connection;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.qpid.AMQConnectionException;
import org.apache.qpid.AMQException;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.connection.IConnectionRegistry;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.virtualhost.VirtualHost;

public class ConnectionRegistry
implements IConnectionRegistry {
    private List<AMQProtocolSession> _registry = new CopyOnWriteArrayList<AMQProtocolSession>();
    private VirtualHost _virtualHost;

    public ConnectionRegistry(VirtualHost virtualHost) {
        this._virtualHost = virtualHost;
    }

    public void initialise() {
    }

    public void close() throws AMQException {
        while (!this._registry.isEmpty()) {
            AMQProtocolSession connection = this._registry.get(0);
            connection.closeConnection(0, new AMQConnectionException(AMQConstant.INTERNAL_ERROR, "Broker is shutting down", 0, 0, connection.getProtocolOutputConverter().getProtocolMajorVersion(), connection.getProtocolOutputConverter().getProtocolMinorVersion(), (Throwable)null), true);
        }
    }

    public void registerConnection(AMQProtocolSession connnection) {
        this._registry.add(connnection);
    }

    public void deregisterConnection(AMQProtocolSession connnection) {
        this._registry.remove(connnection);
    }
}

