/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ManagedExchange;
import org.apache.qpid.server.management.AMQManagedObject;
import org.apache.qpid.server.management.Managable;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.management.ManagedObjectRegistry;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

public abstract class AbstractExchange
implements Exchange,
Managable {
    private AMQShortString _name;
    protected boolean _durable;
    protected String _exchangeType;
    protected int _ticket;
    private VirtualHost _virtualHost;
    protected ExchangeMBean _exchangeMbean;
    protected boolean _autoDelete;

    public AMQShortString getName() {
        return this._name;
    }

    protected abstract ExchangeMBean createMBean() throws AMQException;

    public void initialise(VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
        this._virtualHost = host;
        this._name = name;
        this._durable = durable;
        this._autoDelete = autoDelete;
        this._ticket = ticket;
        this._exchangeMbean = this.createMBean();
        this._exchangeMbean.register();
    }

    public boolean isDurable() {
        return this._durable;
    }

    public boolean isAutoDelete() {
        return this._autoDelete;
    }

    public int getTicket() {
        return this._ticket;
    }

    public void close() throws AMQException {
        if (this._exchangeMbean != null) {
            this._exchangeMbean.unregister();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    public ManagedObject getManagedObject() {
        return this._exchangeMbean;
    }

    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    public QueueRegistry getQueueRegistry() {
        return this.getVirtualHost().getQueueRegistry();
    }

    protected abstract class ExchangeMBean
    extends AMQManagedObject
    implements ManagedExchange {
        protected String[] _bindingItemNames;
        protected String[] _bindingItemIndexNames;
        protected OpenType[] _bindingItemTypes;
        protected CompositeType _bindingDataType;
        protected TabularType _bindinglistDataType;
        protected TabularDataSupport _bindingList;

        public ExchangeMBean() throws NotCompliantMBeanException {
            super(ManagedExchange.class, "Exchange", 1);
        }

        protected void init() throws OpenDataException {
            this._bindingItemNames = new String[]{"Binding Key", "Queue Names"};
            this._bindingItemIndexNames = new String[]{this._bindingItemNames[0]};
            this._bindingItemTypes = new OpenType[2];
            this._bindingItemTypes[0] = SimpleType.STRING;
            this._bindingItemTypes[1] = new ArrayType(1, SimpleType.STRING);
            this._bindingDataType = new CompositeType("Exchange Binding", "Binding key and Queue names", this._bindingItemNames, this._bindingItemNames, this._bindingItemTypes);
            this._bindinglistDataType = new TabularType("Exchange Bindings", "Exchange Bindings for " + this.getName(), this._bindingDataType, this._bindingItemIndexNames);
        }

        public ManagedObject getParentObject() {
            return AbstractExchange.this._virtualHost.getManagedObject();
        }

        public String getObjectInstanceName() {
            return AbstractExchange.this._name.toString();
        }

        public String getName() {
            return AbstractExchange.this._name.toString();
        }

        public String getExchangeType() {
            return AbstractExchange.this._exchangeType;
        }

        public Integer getTicketNo() {
            return AbstractExchange.this._ticket;
        }

        public boolean isDurable() {
            return AbstractExchange.this._durable;
        }

        public boolean isAutoDelete() {
            return AbstractExchange.this._autoDelete;
        }

        public ObjectName getObjectName() throws MalformedObjectNameException {
            String objNameString = super.getObjectName().toString();
            objNameString = objNameString + ",ExchangeType=" + AbstractExchange.this._exchangeType;
            return new ObjectName(objNameString);
        }

        protected ManagedObjectRegistry getManagedObjectRegistry() {
            return ApplicationRegistry.getInstance().getManagedObjectRegistry();
        }
    }
}

