/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.exchange.Index;
import org.apache.qpid.server.management.MBeanConstructor;
import org.apache.qpid.server.management.MBeanDescription;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.IncomingMessage;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectExchange
extends AbstractExchange {
    private static final Logger _logger = Logger.getLogger(DirectExchange.class);
    private final Index _index = new Index();
    public static final ExchangeType<DirectExchange> TYPE = new ExchangeType<DirectExchange>(){

        @Override
        public AMQShortString getName() {
            return ExchangeDefaults.DIRECT_EXCHANGE_CLASS;
        }

        @Override
        public Class<DirectExchange> getExchangeClass() {
            return DirectExchange.class;
        }

        @Override
        public DirectExchange newInstance(VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
            DirectExchange exch = new DirectExchange();
            exch.initialise(host, name, durable, ticket, autoDelete);
            return exch;
        }

        @Override
        public AMQShortString getDefaultExchangeName() {
            return ExchangeDefaults.DIRECT_EXCHANGE_NAME;
        }
    };

    @Override
    protected AbstractExchange.ExchangeMBean createMBean() throws AMQException {
        try {
            return new DirectExchangeMBean();
        }
        catch (JMException ex) {
            _logger.error((Object)"Exception occured in creating the direct exchange mbean", (Throwable)ex);
            throw new AMQException("Exception occured in creating the direct exchange mbean", (Throwable)ex);
        }
    }

    @Override
    public AMQShortString getType() {
        return ExchangeDefaults.DIRECT_EXCHANGE_CLASS;
    }

    @Override
    public void registerQueue(AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQException {
        assert (queue != null);
        assert (routingKey != null);
        if (!this._index.add(routingKey, queue)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Queue (" + queue + ") is already registered with routing key " + routingKey));
            }
        } else if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Binding queue:" + queue + " with routing key '" + routingKey + "' to exchange:" + this));
        }
    }

    @Override
    public void deregisterQueue(AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQException {
        assert (queue != null);
        assert (routingKey != null);
        if (!this._index.remove(routingKey, queue)) {
            throw new AMQException(AMQConstant.NOT_FOUND, "Queue " + queue + " was not registered with exchange " + this.getName() + " with routing key " + routingKey + ". No queue was registered with that _routing key");
        }
    }

    @Override
    public void route(IncomingMessage payload) throws AMQException {
        ArrayList<AMQQueue> queues;
        AMQShortString routingKey = payload.getRoutingKey() == null ? AMQShortString.EMPTY_STRING : payload.getRoutingKey();
        ArrayList<AMQQueue> arrayList = queues = routingKey == null ? null : this._index.get(routingKey);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Publishing message to queue " + queues));
        }
        payload.enqueue(queues);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        return this.isBound(routingKey, queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        ArrayList<AMQQueue> queues = this._index.get(routingKey);
        return queues != null && queues.contains(queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        ArrayList<AMQQueue> queues = this._index.get(routingKey);
        return queues != null && !queues.isEmpty();
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        Map<AMQShortString, List<AMQQueue>> bindings = this._index.getBindingsMap();
        for (List<AMQQueue> queues : bindings.values()) {
            if (!queues.contains(queue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBindings() {
        return !this._index.getBindingsMap().isEmpty();
    }

    public Map<AMQShortString, List<AMQQueue>> getBindings() {
        return this._index.getBindingsMap();
    }

    @MBeanDescription(value="Management Bean for Direct Exchange")
    private final class DirectExchangeMBean
    extends AbstractExchange.ExchangeMBean {
        @MBeanConstructor(value="Creates an MBean for AMQ direct exchange")
        public DirectExchangeMBean() throws JMException {
            DirectExchange.this._exchangeType = "direct";
            this.init();
        }

        public TabularData bindings() throws OpenDataException {
            Map<AMQShortString, List<AMQQueue>> bindings = DirectExchange.this._index.getBindingsMap();
            this._bindingList = new TabularDataSupport(this._bindinglistDataType);
            for (Map.Entry<AMQShortString, List<AMQQueue>> entry : bindings.entrySet()) {
                AMQShortString key = entry.getKey();
                ArrayList<String> queueList = new ArrayList<String>();
                List<AMQQueue> queues = entry.getValue();
                for (AMQQueue q : queues) {
                    queueList.add(q.getName().toString());
                }
                Object[] bindingItemValues = new Object[]{key.toString(), queueList.toArray(new String[0])};
                CompositeDataSupport bindingData = new CompositeDataSupport(this._bindingDataType, this._bindingItemNames, bindingItemValues);
                this._bindingList.put(bindingData);
            }
            return this._bindingList;
        }

        public void createNewBinding(String queueName, String binding) throws JMException {
            AMQQueue queue = DirectExchange.this.getQueueRegistry().getQueue(new AMQShortString(queueName));
            if (queue == null) {
                throw new JMException("Queue \"" + queueName + "\" is not registered with the exchange.");
            }
            try {
                queue.bind(DirectExchange.this, new AMQShortString(binding), null);
            }
            catch (AMQException ex) {
                throw new MBeanException((Exception)((Object)ex));
            }
        }
    }
}

