/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.management.MBeanConstructor;
import org.apache.qpid.server.management.MBeanDescription;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.IncomingMessage;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FanoutExchange
extends AbstractExchange {
    private static final Logger _logger = Logger.getLogger(FanoutExchange.class);
    private final CopyOnWriteArraySet<AMQQueue> _queues = new CopyOnWriteArraySet();
    public static final ExchangeType<FanoutExchange> TYPE = new ExchangeType<FanoutExchange>(){

        @Override
        public AMQShortString getName() {
            return ExchangeDefaults.FANOUT_EXCHANGE_CLASS;
        }

        @Override
        public Class<FanoutExchange> getExchangeClass() {
            return FanoutExchange.class;
        }

        @Override
        public FanoutExchange newInstance(VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
            FanoutExchange exch = new FanoutExchange();
            exch.initialise(host, name, durable, ticket, autoDelete);
            return exch;
        }

        @Override
        public AMQShortString getDefaultExchangeName() {
            return ExchangeDefaults.FANOUT_EXCHANGE_NAME;
        }
    };

    @Override
    protected AbstractExchange.ExchangeMBean createMBean() throws AMQException {
        try {
            return new FanoutExchangeMBean();
        }
        catch (JMException ex) {
            _logger.error((Object)"Exception occured in creating the direct exchange mbean", (Throwable)ex);
            throw new AMQException("Exception occured in creating the direct exchange mbean", (Throwable)ex);
        }
    }

    public Map<AMQShortString, List<AMQQueue>> getBindings() {
        return null;
    }

    @Override
    public AMQShortString getType() {
        return ExchangeDefaults.FANOUT_EXCHANGE_CLASS;
    }

    @Override
    public void registerQueue(AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQException {
        assert (queue != null);
        if (this._queues.contains(queue)) {
            _logger.debug((Object)("Queue " + queue + " is already registered"));
        } else {
            this._queues.add(queue);
            _logger.debug((Object)("Binding queue " + queue + " with routing key " + routingKey + " to exchange " + this));
        }
    }

    @Override
    public void deregisterQueue(AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQException {
        assert (queue != null);
        if (!this._queues.remove(queue)) {
            throw new AMQException(AMQConstant.NOT_FOUND, "Queue " + queue + " was not registered with exchange " + this.getName() + ". ");
        }
    }

    @Override
    public void route(IncomingMessage payload) throws AMQException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Publishing message to queue " + this._queues));
        }
        payload.enqueue(new ArrayList<AMQQueue>(this._queues));
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        return this.isBound(routingKey, queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        return this._queues.contains(queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        return this._queues != null && !this._queues.isEmpty();
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        return this._queues.contains(queue);
    }

    @Override
    public boolean hasBindings() {
        return !this._queues.isEmpty();
    }

    @MBeanDescription(value="Management Bean for Fanout Exchange")
    private final class FanoutExchangeMBean
    extends AbstractExchange.ExchangeMBean {
        @MBeanConstructor(value="Creates an MBean for AMQ fanout exchange")
        public FanoutExchangeMBean() throws JMException {
            FanoutExchange.this._exchangeType = "fanout";
            this.init();
        }

        public TabularData bindings() throws OpenDataException {
            this._bindingList = new TabularDataSupport(this._bindinglistDataType);
            for (AMQQueue queue : FanoutExchange.this._queues) {
                String queueName = queue.getName().toString();
                Object[] bindingItemValues = new Object[]{queueName, new String[]{queueName}};
                CompositeDataSupport bindingData = new CompositeDataSupport(this._bindingDataType, this._bindingItemNames, bindingItemValues);
                this._bindingList.put(bindingData);
            }
            return this._bindingList;
        }

        public void createNewBinding(String queueName, String binding) throws JMException {
            AMQQueue queue = FanoutExchange.this.getQueueRegistry().getQueue(new AMQShortString(queueName));
            if (queue == null) {
                throw new JMException("Queue \"" + queueName + "\" is not registered with the exchange.");
            }
            try {
                queue.bind(FanoutExchange.this, new AMQShortString(binding), null);
            }
            catch (AMQException ex) {
                throw new MBeanException((Exception)((Object)ex));
            }
        }
    }
}

