/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.qpid.framing.AMQTypedValue;
import org.apache.qpid.framing.FieldTable;

class HeadersBinding {
    private static final Logger _logger = Logger.getLogger(HeadersBinding.class);
    private final FieldTable _mappings;
    private final Set<String> required = new HashSet<String>();
    private final Map<String, Object> matches = new HashMap<String, Object>();
    private boolean matchAny;

    HeadersBinding(FieldTable mappings) {
        this._mappings = mappings;
        this.initMappings();
    }

    private void initMappings() {
        this._mappings.processOverElements(new FieldTable.FieldTableElementProcessor(){

            public boolean processElement(String propertyName, AMQTypedValue value) {
                if (HeadersBinding.isSpecial(propertyName)) {
                    HeadersBinding.this.processSpecial(propertyName, value.getValue());
                } else if (value.getValue() == null || value.getValue().equals("")) {
                    HeadersBinding.this.required.add(propertyName);
                } else {
                    HeadersBinding.this.matches.put(propertyName, value.getValue());
                }
                return true;
            }

            public Object getResult() {
                return null;
            }
        });
    }

    protected FieldTable getMappings() {
        return this._mappings;
    }

    public boolean matches(FieldTable headers) {
        if (headers == null) {
            return this.required.isEmpty() && this.matches.isEmpty();
        }
        return this.matchAny ? this.or(headers) : this.and(headers);
    }

    private boolean and(FieldTable headers) {
        if (headers.keys().containsAll(this.required)) {
            for (Map.Entry<String, Object> e : this.matches.entrySet()) {
                if (e.getValue().equals(headers.getObject(e.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean or(FieldTable headers) {
        if (this.required.isEmpty() || !((Boolean)headers.processOverElements((FieldTable.FieldTableElementProcessor)new RequiredOrProcessor())).booleanValue()) {
            return !this.matches.isEmpty() && (Boolean)headers.processOverElements((FieldTable.FieldTableElementProcessor)new MatchesOrProcessor()) != false || this.required.isEmpty() && this.matches.isEmpty();
        }
        return true;
    }

    private void processSpecial(String key, Object value) {
        if ("X-match".equalsIgnoreCase(key)) {
            this.matchAny = this.isAny(value);
        } else {
            _logger.warn((Object)("Ignoring special header: " + key));
        }
    }

    private boolean isAny(Object value) {
        if (value instanceof String) {
            if ("any".equalsIgnoreCase((String)value)) {
                return true;
            }
            if ("all".equalsIgnoreCase((String)value)) {
                return false;
            }
        }
        _logger.warn((Object)("Ignoring unrecognised match type: " + value));
        return false;
    }

    static boolean isSpecial(Object key) {
        return key instanceof String && HeadersBinding.isSpecial((String)key);
    }

    static boolean isSpecial(String key) {
        return key.startsWith("X-") || key.startsWith("x-");
    }

    private final class RequiredOrProcessor
    implements FieldTable.FieldTableElementProcessor {
        Boolean _result = Boolean.FALSE;

        private RequiredOrProcessor() {
        }

        public boolean processElement(String propertyName, AMQTypedValue value) {
            if (HeadersBinding.this.required.contains(propertyName)) {
                this._result = Boolean.TRUE;
                return false;
            }
            return true;
        }

        public Object getResult() {
            return this._result;
        }
    }

    private final class MatchesOrProcessor
    implements FieldTable.FieldTableElementProcessor {
        private Boolean _result = Boolean.FALSE;

        private MatchesOrProcessor() {
        }

        public boolean processElement(String propertyName, AMQTypedValue value) {
            if (value != null && value.getValue() != null && value.getValue().equals(HeadersBinding.this.matches.get(propertyName))) {
                this._result = Boolean.TRUE;
                return false;
            }
            return true;
        }

        public Object getResult() {
            return this._result;
        }
    }
}

