/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.JMException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.AMQTypedValue;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.exchange.HeadersBinding;
import org.apache.qpid.server.management.MBeanConstructor;
import org.apache.qpid.server.management.MBeanDescription;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.IncomingMessage;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadersExchange
extends AbstractExchange {
    private static final Logger _logger = Logger.getLogger(HeadersExchange.class);
    public static final ExchangeType<HeadersExchange> TYPE = new ExchangeType<HeadersExchange>(){

        @Override
        public AMQShortString getName() {
            return ExchangeDefaults.HEADERS_EXCHANGE_CLASS;
        }

        @Override
        public Class<HeadersExchange> getExchangeClass() {
            return HeadersExchange.class;
        }

        @Override
        public HeadersExchange newInstance(VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
            HeadersExchange exch = new HeadersExchange();
            exch.initialise(host, name, durable, ticket, autoDelete);
            return exch;
        }

        @Override
        public AMQShortString getDefaultExchangeName() {
            return ExchangeDefaults.HEADERS_EXCHANGE_NAME;
        }
    };
    private final List<Registration> _bindings = new CopyOnWriteArrayList<Registration>();

    @Override
    public AMQShortString getType() {
        return ExchangeDefaults.HEADERS_EXCHANGE_CLASS;
    }

    @Override
    public void registerQueue(AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQException {
        _logger.debug((Object)("Exchange " + this.getName() + ": Binding " + queue.getName() + " with " + args));
        this._bindings.add(new Registration(new HeadersBinding(args), queue));
    }

    @Override
    public void deregisterQueue(AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQException {
        _logger.debug((Object)("Exchange " + this.getName() + ": Unbinding " + queue.getName()));
        if (!this._bindings.remove(new Registration(new HeadersBinding(args), queue))) {
            throw new AMQException(AMQConstant.NOT_FOUND, "Queue " + queue + " was not registered with exchange " + this.getName() + " with headers args " + args);
        }
    }

    @Override
    public void route(IncomingMessage payload) throws AMQException {
        FieldTable headers = this.getHeaders(payload.getContentHeaderBody());
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Exchange " + this.getName() + ": routing message with headers " + headers));
        }
        boolean routed = false;
        ArrayList<AMQQueue> queues = new ArrayList<AMQQueue>();
        for (Registration e : this._bindings) {
            if (!e.binding.matches(headers)) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Exchange " + this.getName() + ": delivering message with headers " + headers + " to " + e.queue.getName()));
            }
            queues.add(e.queue);
            routed = true;
        }
        payload.enqueue(queues);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        return this.isBound(routingKey, queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        return this.isBound(queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        return this.hasBindings();
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        for (Registration r : this._bindings) {
            if (!r.queue.equals(queue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBindings() {
        return !this._bindings.isEmpty();
    }

    protected FieldTable getHeaders(ContentHeaderBody contentHeaderFrame) {
        return ((BasicContentHeaderProperties)contentHeaderFrame.properties).getHeaders();
    }

    @Override
    protected AbstractExchange.ExchangeMBean createMBean() throws AMQException {
        try {
            return new HeadersExchangeMBean();
        }
        catch (JMException ex) {
            _logger.error((Object)"Exception occured in creating the HeadersExchangeMBean", (Throwable)ex);
            throw new AMQException("Exception occured in creating the HeadersExchangeMBean", (Throwable)ex);
        }
    }

    public Map<AMQShortString, List<AMQQueue>> getBindings() {
        return null;
    }

    private static class Registration {
        private final HeadersBinding binding;
        private final AMQQueue queue;

        Registration(HeadersBinding binding, AMQQueue queue) {
            this.binding = binding;
            this.queue = queue;
        }

        public int hashCode() {
            return this.queue.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Registration && ((Registration)o).queue.equals(this.queue);
        }
    }

    @MBeanDescription(value="Management Bean for Headers Exchange")
    private final class HeadersExchangeMBean
    extends AbstractExchange.ExchangeMBean {
        @MBeanConstructor(value="Creates an MBean for AMQ Headers exchange")
        public HeadersExchangeMBean() throws JMException {
            HeadersExchange.this._exchangeType = "headers";
            this.init();
        }

        protected void init() throws OpenDataException {
            this._bindingItemNames = new String[]{"Binding No", "Queue  Name", "Queue Bindings"};
            this._bindingItemIndexNames = new String[]{this._bindingItemNames[0]};
            this._bindingItemTypes = new OpenType[3];
            this._bindingItemTypes[0] = SimpleType.INTEGER;
            this._bindingItemTypes[1] = SimpleType.STRING;
            this._bindingItemTypes[2] = new ArrayType(1, SimpleType.STRING);
            this._bindingDataType = new CompositeType("Exchange Binding", "Queue name and header bindings", this._bindingItemNames, this._bindingItemNames, this._bindingItemTypes);
            this._bindinglistDataType = new TabularType("Exchange Bindings", "List of exchange bindings for " + this.getName(), this._bindingDataType, this._bindingItemIndexNames);
        }

        public TabularData bindings() throws OpenDataException {
            this._bindingList = new TabularDataSupport(this._bindinglistDataType);
            int count = 1;
            for (Registration registration : HeadersExchange.this._bindings) {
                String queueName = registration.queue.getName().toString();
                HeadersBinding headers = registration.binding;
                FieldTable headerMappings = headers.getMappings();
                final ArrayList mappingList = new ArrayList();
                headerMappings.processOverElements(new FieldTable.FieldTableElementProcessor(){

                    public boolean processElement(String propertyName, AMQTypedValue value) {
                        mappingList.add(propertyName + "=" + value.getValue());
                        return true;
                    }

                    public Object getResult() {
                        return mappingList;
                    }
                });
                Object[] bindingItemValues = new Object[]{count++, queueName, mappingList.toArray(new String[0])};
                CompositeDataSupport bindingData = new CompositeDataSupport(this._bindingDataType, this._bindingItemNames, bindingItemValues);
                this._bindingList.put(bindingData);
            }
            return this._bindingList;
        }

        public void createNewBinding(String queueName, String binding) throws JMException {
            AMQQueue queue = HeadersExchange.this.getQueueRegistry().getQueue(new AMQShortString(queueName));
            if (queue == null) {
                throw new JMException("Queue \"" + queueName + "\" is not registered with the exchange.");
            }
            String[] bindings = binding.split(",");
            FieldTable bindingMap = new FieldTable();
            for (int i = 0; i < bindings.length; ++i) {
                String[] keyAndValue = bindings[i].split("=");
                if (keyAndValue == null || keyAndValue.length < 2) {
                    throw new JMException("Format for headers binding should be \"<attribute1>=<value1>,<attribute2>=<value2>\" ");
                }
                bindingMap.setString(keyAndValue[0], keyAndValue[1]);
            }
            HeadersExchange.this._bindings.add(new Registration(new HeadersBinding(bindingMap), queue));
        }
    }
}

