/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.queue.AMQQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Index {
    private ConcurrentMap<AMQShortString, ArrayList<AMQQueue>> _index = new ConcurrentHashMap<AMQShortString, ArrayList<AMQQueue>>();

    Index() {
    }

    synchronized boolean add(AMQShortString key, AMQQueue queue) {
        ArrayList<AMQQueue> queues = (ArrayList<AMQQueue>)this._index.get(key);
        queues = queues == null ? new ArrayList<AMQQueue>() : new ArrayList(queues);
        this._index.put(key, queues);
        if (queues.contains(queue)) {
            return false;
        }
        return queues.add(queue);
    }

    synchronized boolean remove(AMQShortString key, AMQQueue queue) {
        ArrayList queues = (ArrayList)this._index.get(key);
        if (queues != null) {
            boolean removed = (queues = new ArrayList(queues)).remove(queue);
            if (removed) {
                if (queues.size() == 0) {
                    this._index.remove(key);
                } else {
                    this._index.put(key, queues);
                }
            }
            return removed;
        }
        return false;
    }

    ArrayList<AMQQueue> get(AMQShortString key) {
        return (ArrayList)this._index.get(key);
    }

    Map<AMQShortString, List<AMQQueue>> getBindingsMap() {
        return new HashMap<AMQShortString, List<AMQQueue>>(this._index);
    }
}

