/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.AMQShortStringTokenizer;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.exchange.topic.TopicMatcherResult;
import org.apache.qpid.server.exchange.topic.TopicParser;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.management.MBeanConstructor;
import org.apache.qpid.server.management.MBeanDescription;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.IncomingMessage;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicExchange
extends AbstractExchange {
    public static final ExchangeType<TopicExchange> TYPE = new ExchangeType<TopicExchange>(){

        @Override
        public AMQShortString getName() {
            return ExchangeDefaults.TOPIC_EXCHANGE_CLASS;
        }

        @Override
        public Class<TopicExchange> getExchangeClass() {
            return TopicExchange.class;
        }

        @Override
        public TopicExchange newInstance(VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
            TopicExchange exch = new TopicExchange();
            exch.initialise(host, name, durable, ticket, autoDelete);
            return exch;
        }

        @Override
        public AMQShortString getDefaultExchangeName() {
            return ExchangeDefaults.TOPIC_EXCHANGE_NAME;
        }
    };
    private static final Logger _logger = Logger.getLogger(TopicExchange.class);
    private static final byte TOPIC_SEPARATOR = 46;
    private static final AMQShortString TOPIC_SEPARATOR_AS_SHORTSTRING = new AMQShortString(".");
    private static final AMQShortString AMQP_STAR_TOKEN = new AMQShortString("*");
    private static final AMQShortString AMQP_HASH_TOKEN = new AMQShortString("#");
    private static final byte HASH_BYTE = 35;
    private static final byte STAR_BYTE = 42;
    private final TopicParser _parser = new TopicParser();
    private final Map<AMQShortString, TopicExchangeResult> _topicExchangeResults = new ConcurrentHashMap<AMQShortString, TopicExchangeResult>();
    private final Map<Binding, FieldTable> _bindings = new HashMap<Binding, FieldTable>();
    private final Map<String, WeakReference<JMSSelectorFilter<RuntimeException>>> _selectorCache = new WeakHashMap<String, WeakReference<JMSSelectorFilter<RuntimeException>>>();

    @Override
    public AMQShortString getType() {
        return ExchangeDefaults.TOPIC_EXCHANGE_CLASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void registerQueue(AMQShortString rKey, AMQQueue queue, FieldTable args) throws AMQException {
        assert (queue != null);
        assert (rKey != null);
        _logger.debug((Object)("Registering queue " + queue.getName() + " with routing key " + rKey));
        AMQShortString routingKey = rKey.contains((byte)35) || rKey.contains((byte)42) ? this.normalize(rKey) : rKey;
        Binding binding = new Binding(rKey, queue, args);
        if (this._bindings.containsKey(binding)) {
            FieldTable oldArgs = this._bindings.get(binding);
            TopicExchangeResult result = this._topicExchangeResults.get(routingKey);
            if (TopicExchange.argumentsContainSelector(args)) {
                if (TopicExchange.argumentsContainSelector(oldArgs)) {
                    result.replaceQueueFilter(queue, this.createSelectorFilter(oldArgs), this.createSelectorFilter(args));
                    return;
                } else {
                    result.addFilteredQueue(queue, this.createSelectorFilter(args));
                    result.removeUnfilteredQueue(queue);
                }
                return;
            } else {
                if (!TopicExchange.argumentsContainSelector(oldArgs)) return;
                result.addUnfilteredQueue(queue);
                result.removeFilteredQueue(queue, this.createSelectorFilter(oldArgs));
            }
            return;
        } else {
            TopicExchangeResult result = this._topicExchangeResults.get(routingKey);
            if (result == null) {
                result = new TopicExchangeResult();
                if (TopicExchange.argumentsContainSelector(args)) {
                    result.addFilteredQueue(queue, this.createSelectorFilter(args));
                } else {
                    result.addUnfilteredQueue(queue);
                }
                this._parser.addBinding(routingKey, result);
                this._topicExchangeResults.put(routingKey, result);
            } else if (TopicExchange.argumentsContainSelector(args)) {
                result.addFilteredQueue(queue, this.createSelectorFilter(args));
            } else {
                result.addUnfilteredQueue(queue);
            }
            this._bindings.put(binding, args);
        }
    }

    private JMSSelectorFilter<RuntimeException> createSelectorFilter(FieldTable args) throws AMQException {
        String selectorString = args.getString(AMQPFilterTypes.JMS_SELECTOR.getValue());
        WeakReference<JMSSelectorFilter<RuntimeException>> selectorRef = this._selectorCache.get(selectorString);
        JMSSelectorFilter<RuntimeException> selector = null;
        if (selectorRef == null || (selector = (JMSSelectorFilter<RuntimeException>)selectorRef.get()) == null) {
            selector = new JMSSelectorFilter<RuntimeException>(selectorString);
            this._selectorCache.put(selectorString, new WeakReference<JMSSelectorFilter<RuntimeException>>(selector));
        }
        return selector;
    }

    private static boolean argumentsContainSelector(FieldTable args) {
        return args != null && args.containsKey(AMQPFilterTypes.JMS_SELECTOR.getValue()) && args.getString(AMQPFilterTypes.JMS_SELECTOR.getValue()).trim().length() != 0;
    }

    private AMQShortString normalize(AMQShortString routingKey) {
        if (routingKey == null) {
            routingKey = AMQShortString.EMPTY_STRING;
        }
        AMQShortStringTokenizer routingTokens = routingKey.tokenize((byte)46);
        ArrayList<Object> subscriptionList = new ArrayList<Object>();
        while (routingTokens.hasMoreTokens()) {
            subscriptionList.add(routingTokens.nextToken());
        }
        int size = subscriptionList.size();
        for (int index = 0; index < size; ++index) {
            if (index + 1 >= size || !((AMQShortString)subscriptionList.get(index)).equals(AMQP_HASH_TOKEN)) continue;
            if (((AMQShortString)subscriptionList.get(index + 1)).equals(AMQP_HASH_TOKEN)) {
                subscriptionList.remove(index);
                --size;
                --index;
            }
            if (!((AMQShortString)subscriptionList.get(index + 1)).equals(AMQP_STAR_TOKEN)) continue;
            subscriptionList.add(index + 1, subscriptionList.remove(index));
        }
        AMQShortString normalizedString = AMQShortString.join(subscriptionList, (AMQShortString)TOPIC_SEPARATOR_AS_SHORTSTRING);
        return normalizedString;
    }

    @Override
    public void route(IncomingMessage payload) throws AMQException {
        AMQShortString routingKey = payload.getRoutingKey();
        ArrayList<AMQQueue> queues = new ArrayList<AMQQueue>();
        queues.addAll(this.getMatchedQueues(payload, routingKey));
        if (queues == null || queues.isEmpty()) {
            _logger.info((Object)("Message routing key: " + payload.getRoutingKey() + " No routes."));
        }
        payload.enqueue(queues);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        Binding binding = new Binding(routingKey, queue, arguments);
        if (arguments == null) {
            return this._bindings.containsKey(binding);
        }
        FieldTable o = this._bindings.get(binding);
        if (o != null) {
            return o.equals((Object)arguments);
        }
        return false;
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        return this.isBound(routingKey, null, queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        for (Binding b : this._bindings.keySet()) {
            if (!b.getBindingKey().equals(routingKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        for (Binding b : this._bindings.keySet()) {
            if (!b.getQueue().equals(queue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBindings() {
        return !this._bindings.isEmpty();
    }

    @Override
    public synchronized void deregisterQueue(AMQShortString rKey, AMQQueue queue, FieldTable args) throws AMQException {
        assert (queue != null);
        assert (rKey != null);
        Binding binding = new Binding(rKey, queue, args);
        if (!this._bindings.containsKey(binding)) {
            throw new AMQException(AMQConstant.NOT_FOUND, "Queue " + queue.getName() + " was not registered with exchange " + this.getName() + " with routing key " + rKey + ".");
        }
        FieldTable bindingArgs = this._bindings.remove(binding);
        AMQShortString bindingKey = this.normalize(rKey);
        TopicExchangeResult result = this._topicExchangeResults.get(bindingKey);
        if (TopicExchange.argumentsContainSelector(bindingArgs)) {
            result.removeFilteredQueue(queue, this.createSelectorFilter(bindingArgs));
        } else {
            result.removeUnfilteredQueue(queue);
        }
    }

    @Override
    protected AbstractExchange.ExchangeMBean createMBean() throws AMQException {
        try {
            return new TopicExchangeMBean();
        }
        catch (JMException ex) {
            _logger.error((Object)"Exception occured in creating the topic exchenge mbean", (Throwable)ex);
            throw new AMQException("Exception occured in creating the topic exchenge mbean", (Throwable)ex);
        }
    }

    private Collection<AMQQueue> getMatchedQueues(IncomingMessage message, AMQShortString routingKey) {
        Collection<TopicMatcherResult> results = this._parser.parse(routingKey);
        if (results.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Collection<AMQQueue> queues = results.size() == 1 ? null : new HashSet<AMQQueue>();
        for (TopicMatcherResult result : results) {
            queues = ((TopicExchangeResult)result).processMessage(message, queues);
        }
        return queues;
    }

    @MBeanDescription(value="Management Bean for Topic Exchange")
    private final class TopicExchangeMBean
    extends AbstractExchange.ExchangeMBean {
        @MBeanConstructor(value="Creates an MBean for AMQ topic exchange")
        public TopicExchangeMBean() throws JMException {
            TopicExchange.this._exchangeType = "topic";
            this.init();
        }

        public TabularData bindings() throws OpenDataException {
            this._bindingList = new TabularDataSupport(this._bindinglistDataType);
            HashMap<String, ArrayList<String>> bindingData = new HashMap<String, ArrayList<String>>();
            for (Binding binding : TopicExchange.this._bindings.keySet()) {
                String key = binding.getBindingKey().toString();
                ArrayList<String> queueNames = (ArrayList<String>)bindingData.get(key);
                if (queueNames == null) {
                    queueNames = new ArrayList<String>();
                    bindingData.put(key, queueNames);
                }
                queueNames.add(binding.getQueue().getName().toString());
            }
            for (Map.Entry entry : bindingData.entrySet()) {
                Object[] bindingItemValues = new Object[]{entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()])};
                CompositeDataSupport bindingCompositeData = new CompositeDataSupport(this._bindingDataType, this._bindingItemNames, bindingItemValues);
                this._bindingList.put(bindingCompositeData);
            }
            return this._bindingList;
        }

        public void createNewBinding(String queueName, String binding) throws JMException {
            AMQQueue queue = TopicExchange.this.getQueueRegistry().getQueue(new AMQShortString(queueName));
            if (queue == null) {
                throw new JMException("Queue \"" + queueName + "\" is not registered with the exchange.");
            }
            try {
                queue.bind(TopicExchange.this, new AMQShortString(binding), null);
            }
            catch (AMQException ex) {
                throw new MBeanException((Exception)((Object)ex));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TopicExchangeResult
    implements TopicMatcherResult {
        private final Map<AMQQueue, Integer> _unfilteredQueues = new ConcurrentHashMap<AMQQueue, Integer>();
        private final ConcurrentHashMap<AMQQueue, Map<MessageFilter<RuntimeException>, Integer>> _filteredQueues = new ConcurrentHashMap();

        private TopicExchangeResult() {
        }

        public void addUnfilteredQueue(AMQQueue queue) {
            Integer instances = this._unfilteredQueues.get(queue);
            if (instances == null) {
                this._unfilteredQueues.put(queue, 1);
            } else {
                this._unfilteredQueues.put(queue, instances + 1);
            }
        }

        public void removeUnfilteredQueue(AMQQueue queue) {
            Integer instances = this._unfilteredQueues.get(queue);
            if (instances == 1) {
                this._unfilteredQueues.remove(queue);
            } else {
                this._unfilteredQueues.put(queue, instances - 1);
            }
        }

        public void addFilteredQueue(AMQQueue queue, MessageFilter<RuntimeException> filter) {
            Integer instances;
            Map<MessageFilter<RuntimeException>, Integer> filters = this._filteredQueues.get(queue);
            if (filters == null) {
                filters = new ConcurrentHashMap<MessageFilter<RuntimeException>, Integer>();
                this._filteredQueues.put(queue, filters);
            }
            if ((instances = filters.get(filter)) == null) {
                filters.put(filter, 1);
            } else {
                filters.put(filter, instances + 1);
            }
        }

        public void removeFilteredQueue(AMQQueue queue, MessageFilter<RuntimeException> filter) {
            Integer instances;
            Map<MessageFilter<RuntimeException>, Integer> filters = this._filteredQueues.get(queue);
            if (filters != null && (instances = filters.get(filter)) != null) {
                if (instances == 1) {
                    filters.remove(filter);
                    if (filters.isEmpty()) {
                        this._filteredQueues.remove(queue);
                    }
                } else {
                    filters.put(filter, instances - 1);
                }
            }
        }

        public void replaceQueueFilter(AMQQueue queue, MessageFilter<RuntimeException> oldFilter, MessageFilter<RuntimeException> newFilter) {
            Map<MessageFilter<RuntimeException>, Integer> filters = this._filteredQueues.get(queue);
            ConcurrentHashMap<MessageFilter<RuntimeException>, Integer> newFilters = new ConcurrentHashMap<MessageFilter<RuntimeException>, Integer>(filters);
            Integer oldFilterInstances = filters.get(oldFilter);
            if (oldFilterInstances == 1) {
                newFilters.remove(oldFilter);
            } else {
                newFilters.put(oldFilter, oldFilterInstances - 1);
            }
            Integer newFilterInstances = filters.get(newFilter);
            if (newFilterInstances == null) {
                newFilters.put(newFilter, 1);
            } else {
                newFilters.put(newFilter, newFilterInstances + 1);
            }
            this._filteredQueues.put(queue, newFilters);
        }

        public Collection<AMQQueue> processMessage(IncomingMessage msg, Collection<AMQQueue> queues) {
            if (queues == null) {
                if (this._filteredQueues.isEmpty()) {
                    return new ArrayList<AMQQueue>(this._unfilteredQueues.keySet());
                }
                queues = new HashSet<AMQQueue>();
            } else if (!(queues instanceof Set)) {
                queues = new HashSet<AMQQueue>(queues);
            }
            queues.addAll(this._unfilteredQueues.keySet());
            if (!this._filteredQueues.isEmpty()) {
                for (Map.Entry<AMQQueue, Map<MessageFilter<RuntimeException>, Integer>> entry : this._filteredQueues.entrySet()) {
                    if (queues.contains(entry.getKey())) continue;
                    for (MessageFilter<RuntimeException> filter : entry.getValue().keySet()) {
                        if (!filter.matches(msg)) continue;
                        queues.add(entry.getKey());
                    }
                }
            }
            return queues;
        }
    }

    public static class Binding {
        private final AMQShortString _bindingKey;
        private final AMQQueue _queue;
        private final FieldTable _args;

        public Binding(AMQShortString bindingKey, AMQQueue queue, FieldTable args) {
            this._bindingKey = bindingKey;
            this._queue = queue;
            this._args = args;
        }

        public AMQShortString getBindingKey() {
            return this._bindingKey;
        }

        public AMQQueue getQueue() {
            return this._queue;
        }

        public int hashCode() {
            return (this._bindingKey == null ? 1 : this._bindingKey.hashCode()) * 31 + this._queue.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Binding) {
                Binding other = (Binding)o;
                return this._queue == other._queue && (this._bindingKey == null ? other._bindingKey == null : this._bindingKey.equals(other._bindingKey));
            }
            return false;
        }
    }
}

