/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.SimpleFilterManager;

public class FilterManagerFactory {
    private static final Logger _logger = Logger.getLogger(FilterManagerFactory.class);

    public static FilterManager createManager(FieldTable filters) throws AMQException {
        SimpleFilterManager manager = null;
        if (filters != null) {
            String selector;
            if (filters.containsKey(AMQPFilterTypes.JMS_SELECTOR.getValue()) && (selector = filters.getString(AMQPFilterTypes.JMS_SELECTOR.getValue())) != null && !selector.equals("")) {
                manager = new SimpleFilterManager();
                manager.add(new JMSSelectorFilter(selector));
            }
        } else {
            _logger.debug((Object)"No Filters found.");
        }
        return manager;
    }
}

