/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.filter.BooleanExpression;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.filter.jms.selector.SelectorParser;
import org.apache.qpid.server.queue.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSSelectorFilter<E extends Exception>
implements MessageFilter<E> {
    private static final Logger _logger = Logger.getLogger(JMSSelectorFilter.class);
    private String _selector;
    private BooleanExpression<E> _matcher;

    public JMSSelectorFilter(String selector) throws AMQException {
        this._selector = selector;
        this._matcher = new SelectorParser().parse(selector);
    }

    @Override
    public boolean matches(Filterable<E> message) throws E {
        boolean match = this._matcher.matches(message);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(message + " match(" + match + ") selector(" + System.identityHashCode(this._selector) + "):" + this._selector));
        }
        return match;
    }

    public String getSelector() {
        return this._selector;
    }
}

