/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import org.apache.qpid.server.filter.BinaryExpression;
import org.apache.qpid.server.filter.BooleanExpression;
import org.apache.qpid.server.queue.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogicExpression<E extends Exception>
extends BinaryExpression<E>
implements BooleanExpression<E> {
    public static <E extends Exception> BooleanExpression createOR(BooleanExpression<E> lvalue, BooleanExpression<E> rvalue) {
        return new OrExpression<E>(lvalue, rvalue);
    }

    public static <E extends Exception> BooleanExpression createAND(BooleanExpression<E> lvalue, BooleanExpression<E> rvalue) {
        return new AndExpression<E>(lvalue, rvalue);
    }

    public LogicExpression(BooleanExpression left, BooleanExpression right) {
        super(left, right);
    }

    @Override
    public abstract Object evaluate(Filterable<E> var1) throws E;

    @Override
    public boolean matches(Filterable<E> message) throws E {
        Object object = this.evaluate(message);
        return object != null && object == Boolean.TRUE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndExpression<E extends Exception>
    extends LogicExpression<E> {
        public AndExpression(BooleanExpression<E> lvalue, BooleanExpression<E> rvalue) {
            super(lvalue, rvalue);
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            Boolean lv = (Boolean)this.left.evaluate(message);
            if (lv == null) {
                return null;
            }
            if (!lv.booleanValue()) {
                return Boolean.FALSE;
            }
            Boolean rv = (Boolean)this.right.evaluate(message);
            return rv == null ? null : rv;
        }

        @Override
        public String getExpressionSymbol() {
            return "AND";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrExpression<E extends Exception>
    extends LogicExpression<E> {
        public OrExpression(BooleanExpression<E> lvalue, BooleanExpression<E> rvalue) {
            super(lvalue, rvalue);
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            Boolean lv = (Boolean)this.left.evaluate(message);
            if (lv != null && lv.booleanValue()) {
                return Boolean.TRUE;
            }
            Boolean rv = (Boolean)this.right.evaluate(message);
            return rv == null ? null : rv;
        }

        @Override
        public String getExpressionSymbol() {
            return "OR";
        }
    }
}

