/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.CommonContentHeaderProperties;
import org.apache.qpid.server.filter.Expression;
import org.apache.qpid.server.queue.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyExpression<E extends Exception>
implements Expression<E> {
    private static final int NON_PERSISTENT = 1;
    private static final int PERSISTENT = 2;
    private static final int DEFAULT_PRIORITY = 4;
    private static final Logger _logger = Logger.getLogger(PropertyExpression.class);
    private static final HashMap<String, Expression<? extends Exception>> JMS_PROPERTY_EXPRESSIONS = new HashMap();
    private final String name;
    private final Expression<E> jmsPropertyExpression;

    public boolean outerTest() {
        return false;
    }

    public PropertyExpression(String name) {
        JMS_PROPERTY_EXPRESSIONS.put("JMSDestination", new Expression<E>(){

            @Override
            public Object evaluate(Filterable<E> message) {
                return null;
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSReplyTo", new ReplyToExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSType", new TypeExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSDeliveryMode", new DeliveryModeExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSPriority", new PriorityExpression());
        JMS_PROPERTY_EXPRESSIONS.put("AMQMessageID", new MessageIDExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSTimestamp", new TimestampExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSCorrelationID", new CorrelationIdExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSExpiration", new ExpirationExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSRedelivered", new Expression<E>(){

            @Override
            public Object evaluate(Filterable message) throws Exception {
                return message.isRedelivered();
            }
        });
        this.name = name;
        this.jmsPropertyExpression = JMS_PROPERTY_EXPRESSIONS.get(name);
    }

    @Override
    public Object evaluate(Filterable<E> message) throws E {
        if (this.jmsPropertyExpression != null) {
            return this.jmsPropertyExpression.evaluate(message);
        }
        CommonContentHeaderProperties _properties = (CommonContentHeaderProperties)message.getContentHeaderBody().properties;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Looking up property:" + this.name));
            _logger.debug((Object)("Properties are:" + _properties.getHeaders().keySet()));
        }
        return _properties.getHeaders().getObject(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.name.equals(((PropertyExpression)o).name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpirationExpression<E extends Exception>
    implements Expression<E> {
        private ExpirationExpression() {
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            CommonContentHeaderProperties _properties = (CommonContentHeaderProperties)message.getContentHeaderBody().properties;
            return _properties.getExpiration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CorrelationIdExpression<E extends Exception>
    implements Expression<E> {
        private CorrelationIdExpression() {
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            CommonContentHeaderProperties _properties = (CommonContentHeaderProperties)message.getContentHeaderBody().properties;
            AMQShortString correlationId = _properties.getCorrelationId();
            return correlationId == null ? null : correlationId.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimestampExpression<E extends Exception>
    implements Expression<E> {
        private TimestampExpression() {
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            CommonContentHeaderProperties _properties = (CommonContentHeaderProperties)message.getContentHeaderBody().properties;
            return _properties.getTimestamp();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageIDExpression<E extends Exception>
    implements Expression<E> {
        private MessageIDExpression() {
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            CommonContentHeaderProperties _properties = (CommonContentHeaderProperties)message.getContentHeaderBody().properties;
            AMQShortString messageId = _properties.getMessageId();
            return messageId == null ? null : messageId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PriorityExpression<E extends Exception>
    implements Expression<E> {
        private PriorityExpression() {
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            CommonContentHeaderProperties _properties = (CommonContentHeaderProperties)message.getContentHeaderBody().properties;
            return (int)_properties.getPriority();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeliveryModeExpression<E extends Exception>
    implements Expression<E> {
        private DeliveryModeExpression() {
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            int mode;
            int n = mode = message.isPersistent() ? 2 : 1;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("JMSDeliveryMode is :" + mode));
            }
            return mode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeExpression<E extends Exception>
    implements Expression<E> {
        private TypeExpression() {
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            CommonContentHeaderProperties _properties = (CommonContentHeaderProperties)message.getContentHeaderBody().properties;
            AMQShortString type = _properties.getType();
            return type == null ? null : type.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReplyToExpression<E extends Exception>
    implements Expression<E> {
        private ReplyToExpression() {
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            CommonContentHeaderProperties _properties = (CommonContentHeaderProperties)message.getContentHeaderBody().properties;
            AMQShortString replyTo = _properties.getReplyTo();
            return replyTo == null ? null : replyTo.toString();
        }
    }
}

