/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.queue.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFilterManager
implements FilterManager<AMQException> {
    private final Logger _logger = Logger.getLogger(SimpleFilterManager.class);
    private final ConcurrentLinkedQueue<MessageFilter<AMQException>> _filters;

    public SimpleFilterManager() {
        this._logger.debug((Object)"Creating SimpleFilterManager");
        this._filters = new ConcurrentLinkedQueue();
    }

    @Override
    public void add(MessageFilter<AMQException> filter) {
        this._filters.add(filter);
    }

    @Override
    public void remove(MessageFilter<AMQException> filter) {
        this._filters.remove(filter);
    }

    @Override
    public boolean allAllow(Filterable<AMQException> msg) {
        for (MessageFilter<AMQException> filter : this._filters) {
            try {
                if (filter.matches(msg)) continue;
                return false;
            }
            catch (AMQException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasFilters() {
        return !this._filters.isEmpty();
    }
}

