/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.qpid.server.filter.BooleanExpression;
import org.apache.qpid.server.filter.Expression;
import org.apache.qpid.server.filter.PropertyExpression;
import org.apache.qpid.server.filter.XPathExpression;
import org.apache.qpid.server.filter.XQueryExpression;
import org.apache.qpid.server.queue.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnaryExpression<E extends Exception>
implements Expression<E> {
    private static final BigDecimal BD_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    protected Expression<E> right;

    public static <E extends Exception> Expression<E> createNegate(Expression<E> left) {
        return new NegativeExpression<E>(left);
    }

    public static <E extends Exception> BooleanExpression createInExpression(PropertyExpression<E> right, List elements, boolean not) {
        Collection t = elements.size() == 0 ? null : (elements.size() < 5 ? elements : new HashSet(elements));
        List inList = t;
        return new InExpression<E>(right, inList, not);
    }

    public static <E extends Exception> BooleanExpression<E> createNOT(BooleanExpression<E> left) {
        return new NotExpression<E>(left);
    }

    public static BooleanExpression createXPath(String xpath) {
        return new XPathExpression(xpath);
    }

    public static BooleanExpression createXQuery(String xpath) {
        return new XQueryExpression(xpath);
    }

    public static <E extends Exception> BooleanExpression createBooleanCast(Expression<E> left) {
        return new BooleanCastExpression<E>(left);
    }

    private static Number negate(Number left) {
        Class<?> clazz = left.getClass();
        if (clazz == Integer.class) {
            return new Integer(-left.intValue());
        }
        if (clazz == Long.class) {
            return new Long(-left.longValue());
        }
        if (clazz == Float.class) {
            return new Float(-left.floatValue());
        }
        if (clazz == Double.class) {
            return new Double(-left.doubleValue());
        }
        if (clazz == BigDecimal.class) {
            BigDecimal bd = (BigDecimal)left;
            if (BD_LONG_MIN_VALUE.compareTo(bd = bd.negate()) == 0) {
                return new Long(Long.MIN_VALUE);
            }
            return bd;
        }
        throw new RuntimeException("Don't know how to negate: " + left);
    }

    public UnaryExpression(Expression left) {
        this.right = left;
    }

    public Expression<E> getRight() {
        return this.right;
    }

    public void setRight(Expression expression) {
        this.right = expression;
    }

    public String toString() {
        return "(" + this.getExpressionSymbol() + " " + this.right.toString() + ")";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public abstract String getExpressionSymbol();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanCastExpression<E extends Exception>
    extends BooleanUnaryExpression<E> {
        public BooleanCastExpression(Expression<E> left) {
            super(left);
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            Object rvalue = this.right.evaluate(message);
            if (rvalue == null) {
                return null;
            }
            if (!rvalue.getClass().equals(Boolean.class)) {
                return Boolean.FALSE;
            }
            return (Boolean)rvalue != false ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public String toString() {
            return this.right.toString();
        }

        @Override
        public String getExpressionSymbol() {
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotExpression<E extends Exception>
    extends BooleanUnaryExpression<E> {
        public NotExpression(BooleanExpression<E> left) {
            super(left);
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            Boolean lvalue = (Boolean)this.right.evaluate(message);
            if (lvalue == null) {
                return null;
            }
            return lvalue != false ? Boolean.FALSE : Boolean.TRUE;
        }

        @Override
        public String getExpressionSymbol() {
            return "NOT";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InExpression<E extends Exception>
    extends BooleanUnaryExpression<E> {
        private final Collection _inList;
        private final boolean _not;

        public InExpression(PropertyExpression<E> right, Collection inList, boolean not) {
            super(right);
            this._inList = inList;
            this._not = not;
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            Object rvalue = this.right.evaluate(message);
            if (rvalue == null) {
                return null;
            }
            if (rvalue.getClass() != String.class) {
                return null;
            }
            if ((this._inList != null && this._inList.contains(rvalue)) ^ this._not) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public String toString() {
            StringBuffer answer = new StringBuffer();
            answer.append(this.right);
            answer.append(" ");
            answer.append(this.getExpressionSymbol());
            answer.append(" ( ");
            int count = 0;
            for (Object o : this._inList) {
                if (count != 0) {
                    answer.append(", ");
                }
                answer.append(o);
                ++count;
            }
            answer.append(" )");
            return answer.toString();
        }

        @Override
        public String getExpressionSymbol() {
            if (this._not) {
                return "NOT IN";
            }
            return "IN";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NegativeExpression<E extends Exception>
    extends UnaryExpression<E> {
        public NegativeExpression(Expression<E> left) {
            super(left);
        }

        @Override
        public Object evaluate(Filterable<E> message) throws E {
            Object rvalue = this.right.evaluate(message);
            if (rvalue == null) {
                return null;
            }
            if (rvalue instanceof Number) {
                return UnaryExpression.negate((Number)rvalue);
            }
            return null;
        }

        @Override
        public String getExpressionSymbol() {
            return "-";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BooleanUnaryExpression<E extends Exception>
    extends UnaryExpression<E>
    implements BooleanExpression<E> {
        public BooleanUnaryExpression(Expression<E> left) {
            super(left);
        }

        @Override
        public boolean matches(Filterable<E> message) throws E {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }
}

