/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.filter.BooleanExpression;
import org.apache.qpid.server.filter.ConstantExpression;
import org.apache.qpid.server.filter.XalanXPathEvaluator;
import org.apache.qpid.server.queue.Filterable;

public final class XPathExpression
implements BooleanExpression {
    private static final Logger log = Logger.getLogger(XPathExpression.class);
    private static final String EVALUATOR_SYSTEM_PROPERTY = "org.apache.qpid.server.filter.XPathEvaluatorClassName";
    private static final String DEFAULT_EVALUATOR_CLASS_NAME = XalanXPathEvaluator.class.getName();
    private static final Constructor EVALUATOR_CONSTRUCTOR;
    private final String xpath;
    private final XPathEvaluator evaluator;

    private static Constructor getXPathEvaluatorConstructor(String cn) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Class<?> c = XPathExpression.class.getClassLoader().loadClass(cn);
        if (!XPathEvaluator.class.isAssignableFrom(c)) {
            throw new ClassCastException("" + c + " is not an instance of " + XPathEvaluator.class);
        }
        return c.getConstructor(String.class);
    }

    XPathExpression(String xpath) {
        this.xpath = xpath;
        this.evaluator = this.createEvaluator(xpath);
    }

    private XPathEvaluator createEvaluator(String xpath2) {
        try {
            return (XPathEvaluator)EVALUATOR_CONSTRUCTOR.newInstance(this.xpath);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("Invalid XPath Expression: " + this.xpath + " reason: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Invalid XPath Expression: " + this.xpath + " reason: " + e.getMessage(), e);
        }
    }

    public Object evaluate(Filterable message) throws AMQException {
        return this.evaluator.evaluate(message) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString() {
        return "XPATH " + ConstantExpression.encodeString(this.xpath);
    }

    public boolean matches(Filterable message) throws AMQException {
        Object object = this.evaluate(message);
        return object != null && object == Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String cn = System.getProperty(EVALUATOR_SYSTEM_PROPERTY, DEFAULT_EVALUATOR_CLASS_NAME);
        Constructor m = null;
        try {
            try {
                m = XPathExpression.getXPathEvaluatorConstructor(cn);
            }
            catch (Throwable e) {
                log.warn((Object)("Invalid " + XPathEvaluator.class.getName() + " implementation: " + cn + ", reason: " + e), e);
                cn = DEFAULT_EVALUATOR_CLASS_NAME;
                try {
                    m = XPathExpression.getXPathEvaluatorConstructor(cn);
                }
                catch (Throwable e2) {
                    log.error((Object)"Default XPath evaluator could not be loaded", e);
                }
            }
        }
        finally {
            EVALUATOR_CONSTRUCTOR = m;
        }
    }

    public static interface XPathEvaluator {
        public boolean evaluate(Filterable var1) throws AMQException;
    }
}

