/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.flow;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.server.flow.FlowCreditManager;

public abstract class AbstractFlowCreditManager
implements FlowCreditManager {
    protected final AtomicBoolean _suspended = new AtomicBoolean(false);
    private final Set<FlowCreditManager.FlowCreditManagerListener> _listeners = new HashSet<FlowCreditManager.FlowCreditManagerListener>();

    public final void addStateListener(FlowCreditManager.FlowCreditManagerListener listener) {
        this._listeners.add(listener);
    }

    public final boolean removeListener(FlowCreditManager.FlowCreditManagerListener listener) {
        return this._listeners.remove(listener);
    }

    private void notifyListeners(boolean suspended) {
        for (FlowCreditManager.FlowCreditManagerListener listener : this._listeners) {
            listener.creditStateChanged(!suspended);
        }
    }

    protected final void setSuspended(boolean suspended) {
        if (this._suspended.compareAndSet(!suspended, suspended)) {
            this.notifyListeners(suspended);
        }
    }

    protected final void notifyIncreaseBytesCredit() {
        this.notifyListeners(false);
    }
}

