/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.flow;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.flow.AbstractFlowCreditManager;
import org.apache.qpid.server.queue.AMQMessage;

public class BytesOnlyCreditManager
extends AbstractFlowCreditManager {
    private final AtomicLong _bytesCredit;

    public BytesOnlyCreditManager(long initialCredit) {
        this._bytesCredit = new AtomicLong(initialCredit);
    }

    public void addCredit(long messageCredit, long bytesCredit) {
        this._bytesCredit.addAndGet(bytesCredit);
        this.setSuspended(false);
    }

    public void removeAllCredit() {
        this._bytesCredit.set(0L);
    }

    public boolean hasCredit() {
        return this._bytesCredit.get() > 0L;
    }

    public boolean useCreditForMessage(AMQMessage msg) {
        long msgSize = msg.getSize();
        if (this.hasCredit()) {
            if (this._bytesCredit.addAndGet(-msgSize) >= 0L) {
                return true;
            }
            this._bytesCredit.addAndGet(msgSize);
            this.setSuspended(true);
            return false;
        }
        return false;
    }
}

