/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.flow;

import org.apache.qpid.server.flow.AbstractFlowCreditManager;
import org.apache.qpid.server.flow.FlowCreditManager;
import org.apache.qpid.server.queue.AMQMessage;

public class MessageAndBytesCreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager {
    private long _messageCredit;
    private long _bytesCredit;

    MessageAndBytesCreditManager(long messageCredit, long bytesCredit) {
        this._messageCredit = messageCredit;
        this._bytesCredit = bytesCredit;
    }

    public synchronized void addCredit(long messageCredit, long bytesCredit) {
        this._messageCredit += messageCredit;
        this._bytesCredit += bytesCredit;
        this.setSuspended(this.hasCredit());
    }

    public synchronized void removeAllCredit() {
        this._messageCredit = 0L;
        this._bytesCredit = 0L;
        this.setSuspended(true);
    }

    public synchronized boolean hasCredit() {
        return this._messageCredit > 0L && this._bytesCredit > 0L;
    }

    public synchronized boolean useCreditForMessage(AMQMessage msg) {
        if (this._messageCredit == 0L) {
            this.setSuspended(true);
            return false;
        }
        long msgSize = msg.getSize();
        if (msgSize > this._bytesCredit) {
            this.setSuspended(true);
            return false;
        }
        --this._messageCredit;
        this._bytesCredit -= msgSize;
        this.setSuspended(false);
        return true;
    }
}

