/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.flow;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.flow.AbstractFlowCreditManager;
import org.apache.qpid.server.flow.FlowCreditManager;
import org.apache.qpid.server.queue.AMQMessage;

public class MessageOnlyCreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager {
    private final AtomicLong _messageCredit;

    public MessageOnlyCreditManager(long initialCredit) {
        this._messageCredit = new AtomicLong(initialCredit);
    }

    public void addCredit(long messageCredit, long bytesCredit) {
        this.setSuspended(false);
        this._messageCredit.addAndGet(messageCredit);
    }

    public void removeAllCredit() {
        this.setSuspended(true);
        this._messageCredit.set(0L);
    }

    public boolean hasCredit() {
        return this._messageCredit.get() > 0L;
    }

    public boolean useCreditForMessage(AMQMessage msg) {
        if (this.hasCredit()) {
            if (this._messageCredit.addAndGet(-1L) >= 0L) {
                this.setSuspended(false);
                return true;
            }
            this._messageCredit.addAndGet(1L);
            this.setSuspended(true);
            return false;
        }
        this.setSuspended(true);
        return false;
    }
}

